// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentPropertiesExtended;
import java.io.IOException;

/**
 * Information from validate template deployment response.
 */
@Fluent
public final class DeploymentValidateResultInner implements JsonSerializable<DeploymentValidateResultInner> {
    /*
     * The deployment validation error.
     */
    private ManagementError error;

    /*
     * The ID of the deployment.
     */
    private String id;

    /*
     * The name of the deployment.
     */
    private String name;

    /*
     * The type of the deployment.
     */
    private String type;

    /*
     * The template deployment properties.
     */
    private DeploymentPropertiesExtended properties;

    /**
     * Creates an instance of DeploymentValidateResultInner class.
     */
    public DeploymentValidateResultInner() {
    }

    /**
     * Get the error property: The deployment validation error.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Get the id property: The ID of the deployment.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the deployment.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the deployment.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the properties property: The template deployment properties.
     * 
     * @return the properties value.
     */
    public DeploymentPropertiesExtended properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The template deployment properties.
     * 
     * @param properties the properties value to set.
     * @return the DeploymentValidateResultInner object itself.
     */
    public DeploymentValidateResultInner withProperties(DeploymentPropertiesExtended properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentValidateResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentValidateResultInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentValidateResultInner.
     */
    public static DeploymentValidateResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentValidateResultInner deserializedDeploymentValidateResultInner
                = new DeploymentValidateResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("error".equals(fieldName)) {
                    deserializedDeploymentValidateResultInner.error = ManagementError.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedDeploymentValidateResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDeploymentValidateResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedDeploymentValidateResultInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDeploymentValidateResultInner.properties
                        = DeploymentPropertiesExtended.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentValidateResultInner;
        });
    }
}
