// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Authorization Profile.
 */
@Immutable
public final class AuthorizationProfile implements JsonSerializable<AuthorizationProfile> {
    /*
     * The requested time
     */
    private OffsetDateTime requestedTime;

    /*
     * The requester
     */
    private String requester;

    /*
     * The requester object id
     */
    private String requesterObjectId;

    /*
     * The approved time
     */
    private OffsetDateTime approvedTime;

    /*
     * The approver
     */
    private String approver;

    /**
     * Creates an instance of AuthorizationProfile class.
     */
    public AuthorizationProfile() {
    }

    /**
     * Get the requestedTime property: The requested time.
     * 
     * @return the requestedTime value.
     */
    public OffsetDateTime requestedTime() {
        return this.requestedTime;
    }

    /**
     * Get the requester property: The requester.
     * 
     * @return the requester value.
     */
    public String requester() {
        return this.requester;
    }

    /**
     * Get the requesterObjectId property: The requester object id.
     * 
     * @return the requesterObjectId value.
     */
    public String requesterObjectId() {
        return this.requesterObjectId;
    }

    /**
     * Get the approvedTime property: The approved time.
     * 
     * @return the approvedTime value.
     */
    public OffsetDateTime approvedTime() {
        return this.approvedTime;
    }

    /**
     * Get the approver property: The approver.
     * 
     * @return the approver value.
     */
    public String approver() {
        return this.approver;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AuthorizationProfile.
     */
    public static AuthorizationProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationProfile deserializedAuthorizationProfile = new AuthorizationProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("requestedTime".equals(fieldName)) {
                    deserializedAuthorizationProfile.requestedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("requester".equals(fieldName)) {
                    deserializedAuthorizationProfile.requester = reader.getString();
                } else if ("requesterObjectId".equals(fieldName)) {
                    deserializedAuthorizationProfile.requesterObjectId = reader.getString();
                } else if ("approvedTime".equals(fieldName)) {
                    deserializedAuthorizationProfile.approvedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("approver".equals(fieldName)) {
                    deserializedAuthorizationProfile.approver = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationProfile;
        });
    }
}
