// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deployment parameter for the template.
 */
@Fluent
public final class DeploymentParameter implements JsonSerializable<DeploymentParameter> {
    /*
     * Input value to the parameter .
     */
    private Object value;

    /*
     * Azure Key Vault parameter reference.
     */
    private KeyVaultParameterReference reference;

    /**
     * Creates an instance of DeploymentParameter class.
     */
    public DeploymentParameter() {
    }

    /**
     * Get the value property: Input value to the parameter .
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: Input value to the parameter .
     * 
     * @param value the value value to set.
     * @return the DeploymentParameter object itself.
     */
    public DeploymentParameter withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the reference property: Azure Key Vault parameter reference.
     * 
     * @return the reference value.
     */
    public KeyVaultParameterReference reference() {
        return this.reference;
    }

    /**
     * Set the reference property: Azure Key Vault parameter reference.
     * 
     * @param reference the reference value to set.
     * @return the DeploymentParameter object itself.
     */
    public DeploymentParameter withReference(KeyVaultParameterReference reference) {
        this.reference = reference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (reference() != null) {
            reference().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.value != null) {
            jsonWriter.writeUntypedField("value", this.value);
        }
        jsonWriter.writeJsonField("reference", this.reference);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentParameter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentParameter.
     */
    public static DeploymentParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentParameter deserializedDeploymentParameter = new DeploymentParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedDeploymentParameter.value = reader.readUntyped();
                } else if ("reference".equals(fieldName)) {
                    deserializedDeploymentParameter.reference = KeyVaultParameterReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentParameter;
        });
    }
}
