// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Deployment What-if properties.
 */
@Fluent
public final class DeploymentWhatIfProperties extends DeploymentProperties {
    /*
     * Optional What-If operation settings.
     */
    private DeploymentWhatIfSettings whatIfSettings;

    /**
     * Creates an instance of DeploymentWhatIfProperties class.
     */
    public DeploymentWhatIfProperties() {
    }

    /**
     * Get the whatIfSettings property: Optional What-If operation settings.
     * 
     * @return the whatIfSettings value.
     */
    public DeploymentWhatIfSettings whatIfSettings() {
        return this.whatIfSettings;
    }

    /**
     * Set the whatIfSettings property: Optional What-If operation settings.
     * 
     * @param whatIfSettings the whatIfSettings value to set.
     * @return the DeploymentWhatIfProperties object itself.
     */
    public DeploymentWhatIfProperties withWhatIfSettings(DeploymentWhatIfSettings whatIfSettings) {
        this.whatIfSettings = whatIfSettings;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties withTemplate(Object template) {
        super.withTemplate(template);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties withTemplateLink(TemplateLink templateLink) {
        super.withTemplateLink(templateLink);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties withParameters(Map<String, DeploymentParameter> parameters) {
        super.withParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties withParametersLink(ParametersLink parametersLink) {
        super.withParametersLink(parametersLink);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties
        withExtensionConfigs(Map<String, Map<String, DeploymentExtensionConfigItem>> extensionConfigs) {
        super.withExtensionConfigs(extensionConfigs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties withMode(DeploymentMode mode) {
        super.withMode(mode);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties withDebugSetting(DebugSetting debugSetting) {
        super.withDebugSetting(debugSetting);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties withOnErrorDeployment(OnErrorDeployment onErrorDeployment) {
        super.withOnErrorDeployment(onErrorDeployment);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties
        withExpressionEvaluationOptions(ExpressionEvaluationOptions expressionEvaluationOptions) {
        super.withExpressionEvaluationOptions(expressionEvaluationOptions);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentWhatIfProperties withValidationLevel(ValidationLevel validationLevel) {
        super.withValidationLevel(validationLevel);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (whatIfSettings() != null) {
            whatIfSettings().validate();
        }
        if (templateLink() != null) {
            templateLink().validate();
        }
        if (parameters() != null) {
            parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (parametersLink() != null) {
            parametersLink().validate();
        }
        if (extensionConfigs() != null) {
            extensionConfigs().values().forEach(e -> {
                if (e != null) {
                    e.values().forEach(e1 -> {
                        if (e1 != null) {
                            e1.validate();
                        }
                    });
                }
            });
        }
        if (mode() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property mode in model DeploymentWhatIfProperties"));
        }
        if (debugSetting() != null) {
            debugSetting().validate();
        }
        if (onErrorDeployment() != null) {
            onErrorDeployment().validate();
        }
        if (expressionEvaluationOptions() != null) {
            expressionEvaluationOptions().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeploymentWhatIfProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", mode() == null ? null : mode().toString());
        if (template() != null) {
            jsonWriter.writeUntypedField("template", template());
        }
        jsonWriter.writeJsonField("templateLink", templateLink());
        jsonWriter.writeMapField("parameters", parameters(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("parametersLink", parametersLink());
        jsonWriter.writeMapField("extensionConfigs", extensionConfigs(),
            (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeJson(element1)));
        jsonWriter.writeJsonField("debugSetting", debugSetting());
        jsonWriter.writeJsonField("onErrorDeployment", onErrorDeployment());
        jsonWriter.writeJsonField("expressionEvaluationOptions", expressionEvaluationOptions());
        jsonWriter.writeStringField("validationLevel", validationLevel() == null ? null : validationLevel().toString());
        jsonWriter.writeJsonField("whatIfSettings", this.whatIfSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentWhatIfProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentWhatIfProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeploymentWhatIfProperties.
     */
    public static DeploymentWhatIfProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentWhatIfProperties deserializedDeploymentWhatIfProperties = new DeploymentWhatIfProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withMode(DeploymentMode.fromString(reader.getString()));
                } else if ("template".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withTemplate(reader.readUntyped());
                } else if ("templateLink".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withTemplateLink(TemplateLink.fromJson(reader));
                } else if ("parameters".equals(fieldName)) {
                    Map<String, DeploymentParameter> parameters
                        = reader.readMap(reader1 -> DeploymentParameter.fromJson(reader1));
                    deserializedDeploymentWhatIfProperties.withParameters(parameters);
                } else if ("parametersLink".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withParametersLink(ParametersLink.fromJson(reader));
                } else if ("extensionConfigs".equals(fieldName)) {
                    Map<String, Map<String, DeploymentExtensionConfigItem>> extensionConfigs = reader.readMap(
                        reader1 -> reader1.readMap(reader2 -> DeploymentExtensionConfigItem.fromJson(reader2)));
                    deserializedDeploymentWhatIfProperties.withExtensionConfigs(extensionConfigs);
                } else if ("debugSetting".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withDebugSetting(DebugSetting.fromJson(reader));
                } else if ("onErrorDeployment".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.withOnErrorDeployment(OnErrorDeployment.fromJson(reader));
                } else if ("expressionEvaluationOptions".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties
                        .withExpressionEvaluationOptions(ExpressionEvaluationOptions.fromJson(reader));
                } else if ("validationLevel".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties
                        .withValidationLevel(ValidationLevel.fromString(reader.getString()));
                } else if ("whatIfSettings".equals(fieldName)) {
                    deserializedDeploymentWhatIfProperties.whatIfSettings = DeploymentWhatIfSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentWhatIfProperties;
        });
    }
}
