// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.PolicyExemptionUpdateProperties;
import java.io.IOException;
import java.util.List;

/**
 * The policy exemption for Patch request.
 */
@Fluent
public final class PolicyExemptionUpdate implements JsonSerializable<PolicyExemptionUpdate> {
    /*
     * The policy exemption properties for Patch request.
     */
    private PolicyExemptionUpdateProperties innerProperties;

    /**
     * Creates an instance of PolicyExemptionUpdate class.
     */
    public PolicyExemptionUpdate() {
    }

    /**
     * Get the innerProperties property: The policy exemption properties for Patch request.
     * 
     * @return the innerProperties value.
     */
    private PolicyExemptionUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @return the resourceSelectors value.
     */
    public List<ResourceSelector> resourceSelectors() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceSelectors();
    }

    /**
     * Set the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @param resourceSelectors the resourceSelectors value to set.
     * @return the PolicyExemptionUpdate object itself.
     */
    public PolicyExemptionUpdate withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionUpdateProperties();
        }
        this.innerProperties().withResourceSelectors(resourceSelectors);
        return this;
    }

    /**
     * Get the assignmentScopeValidation property: The option whether validate the exemption is at or under the
     * assignment scope.
     * 
     * @return the assignmentScopeValidation value.
     */
    public AssignmentScopeValidation assignmentScopeValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().assignmentScopeValidation();
    }

    /**
     * Set the assignmentScopeValidation property: The option whether validate the exemption is at or under the
     * assignment scope.
     * 
     * @param assignmentScopeValidation the assignmentScopeValidation value to set.
     * @return the PolicyExemptionUpdate object itself.
     */
    public PolicyExemptionUpdate withAssignmentScopeValidation(AssignmentScopeValidation assignmentScopeValidation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionUpdateProperties();
        }
        this.innerProperties().withAssignmentScopeValidation(assignmentScopeValidation);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyExemptionUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyExemptionUpdate if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyExemptionUpdate.
     */
    public static PolicyExemptionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyExemptionUpdate deserializedPolicyExemptionUpdate = new PolicyExemptionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedPolicyExemptionUpdate.innerProperties
                        = PolicyExemptionUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyExemptionUpdate;
        });
    }
}
