// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The provider consent.
 */
@Fluent
public final class ProviderConsentDefinition implements JsonSerializable<ProviderConsentDefinition> {
    /*
     * A value indicating whether authorization is consented or not.
     */
    private Boolean consentToAuthorization;

    /**
     * Creates an instance of ProviderConsentDefinition class.
     */
    public ProviderConsentDefinition() {
    }

    /**
     * Get the consentToAuthorization property: A value indicating whether authorization is consented or not.
     * 
     * @return the consentToAuthorization value.
     */
    public Boolean consentToAuthorization() {
        return this.consentToAuthorization;
    }

    /**
     * Set the consentToAuthorization property: A value indicating whether authorization is consented or not.
     * 
     * @param consentToAuthorization the consentToAuthorization value to set.
     * @return the ProviderConsentDefinition object itself.
     */
    public ProviderConsentDefinition withConsentToAuthorization(Boolean consentToAuthorization) {
        this.consentToAuthorization = consentToAuthorization;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("consentToAuthorization", this.consentToAuthorization);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProviderConsentDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProviderConsentDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProviderConsentDefinition.
     */
    public static ProviderConsentDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderConsentDefinition deserializedProviderConsentDefinition = new ProviderConsentDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("consentToAuthorization".equals(fieldName)) {
                    deserializedProviderConsentDefinition.consentToAuthorization
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProviderConsentDefinition;
        });
    }
}
