// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The provider permission.
 */
@Fluent
public final class ProviderPermission implements JsonSerializable<ProviderPermission> {
    /*
     * The application id.
     */
    private String applicationId;

    /*
     * Role definition properties.
     */
    private RoleDefinition roleDefinition;

    /*
     * Role definition properties.
     */
    private RoleDefinition managedByRoleDefinition;

    /*
     * The provider authorization consent state.
     */
    private ProviderAuthorizationConsentState providerAuthorizationConsentState;

    /**
     * Creates an instance of ProviderPermission class.
     */
    public ProviderPermission() {
    }

    /**
     * Get the applicationId property: The application id.
     * 
     * @return the applicationId value.
     */
    public String applicationId() {
        return this.applicationId;
    }

    /**
     * Set the applicationId property: The application id.
     * 
     * @param applicationId the applicationId value to set.
     * @return the ProviderPermission object itself.
     */
    public ProviderPermission withApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    /**
     * Get the roleDefinition property: Role definition properties.
     * 
     * @return the roleDefinition value.
     */
    public RoleDefinition roleDefinition() {
        return this.roleDefinition;
    }

    /**
     * Set the roleDefinition property: Role definition properties.
     * 
     * @param roleDefinition the roleDefinition value to set.
     * @return the ProviderPermission object itself.
     */
    public ProviderPermission withRoleDefinition(RoleDefinition roleDefinition) {
        this.roleDefinition = roleDefinition;
        return this;
    }

    /**
     * Get the managedByRoleDefinition property: Role definition properties.
     * 
     * @return the managedByRoleDefinition value.
     */
    public RoleDefinition managedByRoleDefinition() {
        return this.managedByRoleDefinition;
    }

    /**
     * Set the managedByRoleDefinition property: Role definition properties.
     * 
     * @param managedByRoleDefinition the managedByRoleDefinition value to set.
     * @return the ProviderPermission object itself.
     */
    public ProviderPermission withManagedByRoleDefinition(RoleDefinition managedByRoleDefinition) {
        this.managedByRoleDefinition = managedByRoleDefinition;
        return this;
    }

    /**
     * Get the providerAuthorizationConsentState property: The provider authorization consent state.
     * 
     * @return the providerAuthorizationConsentState value.
     */
    public ProviderAuthorizationConsentState providerAuthorizationConsentState() {
        return this.providerAuthorizationConsentState;
    }

    /**
     * Set the providerAuthorizationConsentState property: The provider authorization consent state.
     * 
     * @param providerAuthorizationConsentState the providerAuthorizationConsentState value to set.
     * @return the ProviderPermission object itself.
     */
    public ProviderPermission
        withProviderAuthorizationConsentState(ProviderAuthorizationConsentState providerAuthorizationConsentState) {
        this.providerAuthorizationConsentState = providerAuthorizationConsentState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (roleDefinition() != null) {
            roleDefinition().validate();
        }
        if (managedByRoleDefinition() != null) {
            managedByRoleDefinition().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("applicationId", this.applicationId);
        jsonWriter.writeJsonField("roleDefinition", this.roleDefinition);
        jsonWriter.writeJsonField("managedByRoleDefinition", this.managedByRoleDefinition);
        jsonWriter.writeStringField("providerAuthorizationConsentState",
            this.providerAuthorizationConsentState == null ? null : this.providerAuthorizationConsentState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProviderPermission from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProviderPermission if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProviderPermission.
     */
    public static ProviderPermission fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderPermission deserializedProviderPermission = new ProviderPermission();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("applicationId".equals(fieldName)) {
                    deserializedProviderPermission.applicationId = reader.getString();
                } else if ("roleDefinition".equals(fieldName)) {
                    deserializedProviderPermission.roleDefinition = RoleDefinition.fromJson(reader);
                } else if ("managedByRoleDefinition".equals(fieldName)) {
                    deserializedProviderPermission.managedByRoleDefinition = RoleDefinition.fromJson(reader);
                } else if ("providerAuthorizationConsentState".equals(fieldName)) {
                    deserializedProviderPermission.providerAuthorizationConsentState
                        = ProviderAuthorizationConsentState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProviderPermission;
        });
    }
}
