// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Wrapper resource for tags patch API request only.
 */
@Fluent
public final class TagsPatchResource implements JsonSerializable<TagsPatchResource> {
    /*
     * The operation type for the patch API.
     */
    private TagsPatchOperation operation;

    /*
     * The set of tags.
     */
    private Tags properties;

    /**
     * Creates an instance of TagsPatchResource class.
     */
    public TagsPatchResource() {
    }

    /**
     * Get the operation property: The operation type for the patch API.
     * 
     * @return the operation value.
     */
    public TagsPatchOperation operation() {
        return this.operation;
    }

    /**
     * Set the operation property: The operation type for the patch API.
     * 
     * @param operation the operation value to set.
     * @return the TagsPatchResource object itself.
     */
    public TagsPatchResource withOperation(TagsPatchOperation operation) {
        this.operation = operation;
        return this;
    }

    /**
     * Get the properties property: The set of tags.
     * 
     * @return the properties value.
     */
    public Tags properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The set of tags.
     * 
     * @param properties the properties value to set.
     * @return the TagsPatchResource object itself.
     */
    public TagsPatchResource withProperties(Tags properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operation", this.operation == null ? null : this.operation.toString());
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagsPatchResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagsPatchResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TagsPatchResource.
     */
    public static TagsPatchResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagsPatchResource deserializedTagsPatchResource = new TagsPatchResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operation".equals(fieldName)) {
                    deserializedTagsPatchResource.operation = TagsPatchOperation.fromString(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedTagsPatchResource.properties = Tags.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagsPatchResource;
        });
    }
}
