// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AvailabilityZoneMappings;
import com.azure.resourcemanager.resources.models.LocationMetadata;
import com.azure.resourcemanager.resources.models.LocationType;
import java.io.IOException;
import java.util.List;

/**
 * Location information.
 */
@Fluent
public final class LocationInner implements JsonSerializable<LocationInner> {
    /*
     * The fully qualified ID of the location. For example,
     * /subscriptions/8d65815f-a5b6-402f-9298-045155da7d74/locations/westus.
     */
    private String id;

    /*
     * The subscription ID.
     */
    private String subscriptionId;

    /*
     * The location name.
     */
    private String name;

    /*
     * The location type.
     */
    private LocationType type;

    /*
     * The display name of the location.
     */
    private String displayName;

    /*
     * The display name of the location and its region.
     */
    private String regionalDisplayName;

    /*
     * Metadata of the location, such as lat/long, paired region, and others.
     */
    private LocationMetadata metadata;

    /*
     * The availability zone mappings for this region.
     */
    private List<AvailabilityZoneMappings> availabilityZoneMappings;

    /**
     * Creates an instance of LocationInner class.
     */
    public LocationInner() {
    }

    /**
     * Get the id property: The fully qualified ID of the location. For example,
     * /subscriptions/8d65815f-a5b6-402f-9298-045155da7d74/locations/westus.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the subscriptionId property: The subscription ID.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Get the name property: The location name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The location type.
     * 
     * @return the type value.
     */
    public LocationType type() {
        return this.type;
    }

    /**
     * Get the displayName property: The display name of the location.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the regionalDisplayName property: The display name of the location and its region.
     * 
     * @return the regionalDisplayName value.
     */
    public String regionalDisplayName() {
        return this.regionalDisplayName;
    }

    /**
     * Get the metadata property: Metadata of the location, such as lat/long, paired region, and others.
     * 
     * @return the metadata value.
     */
    public LocationMetadata metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Metadata of the location, such as lat/long, paired region, and others.
     * 
     * @param metadata the metadata value to set.
     * @return the LocationInner object itself.
     */
    public LocationInner withMetadata(LocationMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the availabilityZoneMappings property: The availability zone mappings for this region.
     * 
     * @return the availabilityZoneMappings value.
     */
    public List<AvailabilityZoneMappings> availabilityZoneMappings() {
        return this.availabilityZoneMappings;
    }

    /**
     * Set the availabilityZoneMappings property: The availability zone mappings for this region.
     * 
     * @param availabilityZoneMappings the availabilityZoneMappings value to set.
     * @return the LocationInner object itself.
     */
    public LocationInner withAvailabilityZoneMappings(List<AvailabilityZoneMappings> availabilityZoneMappings) {
        this.availabilityZoneMappings = availabilityZoneMappings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metadata() != null) {
            metadata().validate();
        }
        if (availabilityZoneMappings() != null) {
            availabilityZoneMappings().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("metadata", this.metadata);
        jsonWriter.writeArrayField("availabilityZoneMappings", this.availabilityZoneMappings,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocationInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocationInner.
     */
    public static LocationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocationInner deserializedLocationInner = new LocationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLocationInner.id = reader.getString();
                } else if ("subscriptionId".equals(fieldName)) {
                    deserializedLocationInner.subscriptionId = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedLocationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedLocationInner.type = LocationType.fromString(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedLocationInner.displayName = reader.getString();
                } else if ("regionalDisplayName".equals(fieldName)) {
                    deserializedLocationInner.regionalDisplayName = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    deserializedLocationInner.metadata = LocationMetadata.fromJson(reader);
                } else if ("availabilityZoneMappings".equals(fieldName)) {
                    List<AvailabilityZoneMappings> availabilityZoneMappings
                        = reader.readArray(reader1 -> AvailabilityZoneMappings.fromJson(reader1));
                    deserializedLocationInner.availabilityZoneMappings = availabilityZoneMappings;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocationInner;
        });
    }
}
