// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ParameterDefinitionsValue;
import com.azure.resourcemanager.resources.models.PolicyDefinitionGroup;
import com.azure.resourcemanager.resources.models.PolicyDefinitionReference;
import com.azure.resourcemanager.resources.models.PolicyType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The policy set definition version.
 */
@Fluent
public final class PolicySetDefinitionVersionInner extends ProxyResource {
    /*
     * The policy set definition version properties.
     */
    private PolicySetDefinitionVersionProperties innerProperties;

    /*
     * The system metadata relating to this resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PolicySetDefinitionVersionInner class.
     */
    public PolicySetDefinitionVersionInner() {
    }

    /**
     * Get the innerProperties property: The policy set definition version properties.
     * 
     * @return the innerProperties value.
     */
    private PolicySetDefinitionVersionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the policyType property: The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom,
     * and Static.
     * 
     * @return the policyType value.
     */
    public PolicyType policyType() {
        return this.innerProperties() == null ? null : this.innerProperties().policyType();
    }

    /**
     * Set the policyType property: The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom,
     * and Static.
     * 
     * @param policyType the policyType value to set.
     * @return the PolicySetDefinitionVersionInner object itself.
     */
    public PolicySetDefinitionVersionInner withPolicyType(PolicyType policyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicySetDefinitionVersionProperties();
        }
        this.innerProperties().withPolicyType(policyType);
        return this;
    }

    /**
     * Get the displayName property: The display name of the policy set definition.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: The display name of the policy set definition.
     * 
     * @param displayName the displayName value to set.
     * @return the PolicySetDefinitionVersionInner object itself.
     */
    public PolicySetDefinitionVersionInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicySetDefinitionVersionProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the description property: The policy set definition description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The policy set definition description.
     * 
     * @param description the description value to set.
     * @return the PolicySetDefinitionVersionInner object itself.
     */
    public PolicySetDefinitionVersionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicySetDefinitionVersionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the metadata property: The policy set definition metadata. Metadata is an open ended object and is typically
     * a collection of key value pairs.
     * 
     * @return the metadata value.
     */
    public Object metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    /**
     * Set the metadata property: The policy set definition metadata. Metadata is an open ended object and is typically
     * a collection of key value pairs.
     * 
     * @param metadata the metadata value to set.
     * @return the PolicySetDefinitionVersionInner object itself.
     */
    public PolicySetDefinitionVersionInner withMetadata(Object metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicySetDefinitionVersionProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    /**
     * Get the parameters property: The policy set definition parameters that can be used in policy definition
     * references.
     * 
     * @return the parameters value.
     */
    public Map<String, ParameterDefinitionsValue> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: The policy set definition parameters that can be used in policy definition
     * references.
     * 
     * @param parameters the parameters value to set.
     * @return the PolicySetDefinitionVersionInner object itself.
     */
    public PolicySetDefinitionVersionInner withParameters(Map<String, ParameterDefinitionsValue> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicySetDefinitionVersionProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Get the policyDefinitions property: An array of policy definition references.
     * 
     * @return the policyDefinitions value.
     */
    public List<PolicyDefinitionReference> policyDefinitions() {
        return this.innerProperties() == null ? null : this.innerProperties().policyDefinitions();
    }

    /**
     * Set the policyDefinitions property: An array of policy definition references.
     * 
     * @param policyDefinitions the policyDefinitions value to set.
     * @return the PolicySetDefinitionVersionInner object itself.
     */
    public PolicySetDefinitionVersionInner withPolicyDefinitions(List<PolicyDefinitionReference> policyDefinitions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicySetDefinitionVersionProperties();
        }
        this.innerProperties().withPolicyDefinitions(policyDefinitions);
        return this;
    }

    /**
     * Get the policyDefinitionGroups property: The metadata describing groups of policy definition references within
     * the policy set definition.
     * 
     * @return the policyDefinitionGroups value.
     */
    public List<PolicyDefinitionGroup> policyDefinitionGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().policyDefinitionGroups();
    }

    /**
     * Set the policyDefinitionGroups property: The metadata describing groups of policy definition references within
     * the policy set definition.
     * 
     * @param policyDefinitionGroups the policyDefinitionGroups value to set.
     * @return the PolicySetDefinitionVersionInner object itself.
     */
    public PolicySetDefinitionVersionInner
        withPolicyDefinitionGroups(List<PolicyDefinitionGroup> policyDefinitionGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicySetDefinitionVersionProperties();
        }
        this.innerProperties().withPolicyDefinitionGroups(policyDefinitionGroups);
        return this;
    }

    /**
     * Get the version property: The policy set definition version in #.#.# format.
     * 
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: The policy set definition version in #.#.# format.
     * 
     * @param version the version value to set.
     * @return the PolicySetDefinitionVersionInner object itself.
     */
    public PolicySetDefinitionVersionInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicySetDefinitionVersionProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicySetDefinitionVersionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicySetDefinitionVersionInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PolicySetDefinitionVersionInner.
     */
    public static PolicySetDefinitionVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicySetDefinitionVersionInner deserializedPolicySetDefinitionVersionInner
                = new PolicySetDefinitionVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionInner.innerProperties
                        = PolicySetDefinitionVersionProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicySetDefinitionVersionInner;
        });
    }
}
