// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Check zone peers request parameters.
 */
@Fluent
public final class CheckZonePeersRequest implements JsonSerializable<CheckZonePeersRequest> {
    /*
     * The Microsoft location.
     */
    private String location;

    /*
     * The peer Microsoft Azure subscription ID.
     */
    private List<String> subscriptionIds;

    /**
     * Creates an instance of CheckZonePeersRequest class.
     */
    public CheckZonePeersRequest() {
    }

    /**
     * Get the location property: The Microsoft location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The Microsoft location.
     * 
     * @param location the location value to set.
     * @return the CheckZonePeersRequest object itself.
     */
    public CheckZonePeersRequest withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the subscriptionIds property: The peer Microsoft Azure subscription ID.
     * 
     * @return the subscriptionIds value.
     */
    public List<String> subscriptionIds() {
        return this.subscriptionIds;
    }

    /**
     * Set the subscriptionIds property: The peer Microsoft Azure subscription ID.
     * 
     * @param subscriptionIds the subscriptionIds value to set.
     * @return the CheckZonePeersRequest object itself.
     */
    public CheckZonePeersRequest withSubscriptionIds(List<String> subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("subscriptionIds", this.subscriptionIds,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckZonePeersRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckZonePeersRequest if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CheckZonePeersRequest.
     */
    public static CheckZonePeersRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckZonePeersRequest deserializedCheckZonePeersRequest = new CheckZonePeersRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("location".equals(fieldName)) {
                    deserializedCheckZonePeersRequest.location = reader.getString();
                } else if ("subscriptionIds".equals(fieldName)) {
                    List<String> subscriptionIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedCheckZonePeersRequest.subscriptionIds = subscriptionIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckZonePeersRequest;
        });
    }
}
