// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters of move resources.
 */
@Fluent
public final class ResourcesMoveInfo implements JsonSerializable<ResourcesMoveInfo> {
    /*
     * The IDs of the resources.
     */
    private List<String> resources;

    /*
     * The target resource group.
     */
    private String targetResourceGroup;

    /**
     * Creates an instance of ResourcesMoveInfo class.
     */
    public ResourcesMoveInfo() {
    }

    /**
     * Get the resources property: The IDs of the resources.
     * 
     * @return the resources value.
     */
    public List<String> resources() {
        return this.resources;
    }

    /**
     * Set the resources property: The IDs of the resources.
     * 
     * @param resources the resources value to set.
     * @return the ResourcesMoveInfo object itself.
     */
    public ResourcesMoveInfo withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Get the targetResourceGroup property: The target resource group.
     * 
     * @return the targetResourceGroup value.
     */
    public String targetResourceGroup() {
        return this.targetResourceGroup;
    }

    /**
     * Set the targetResourceGroup property: The target resource group.
     * 
     * @param targetResourceGroup the targetResourceGroup value to set.
     * @return the ResourcesMoveInfo object itself.
     */
    public ResourcesMoveInfo withTargetResourceGroup(String targetResourceGroup) {
        this.targetResourceGroup = targetResourceGroup;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("targetResourceGroup", this.targetResourceGroup);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourcesMoveInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourcesMoveInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourcesMoveInfo.
     */
    public static ResourcesMoveInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourcesMoveInfo deserializedResourcesMoveInfo = new ResourcesMoveInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resources".equals(fieldName)) {
                    List<String> resources = reader.readArray(reader1 -> reader1.getString());
                    deserializedResourcesMoveInfo.resources = resources;
                } else if ("targetResourceGroup".equals(fieldName)) {
                    deserializedResourcesMoveInfo.targetResourceGroup = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourcesMoveInfo;
        });
    }
}
