// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Tag count.
 */
@Fluent
public final class TagCount implements JsonSerializable<TagCount> {
    /*
     * Type of count.
     */
    private String type;

    /*
     * Value of count.
     */
    private Integer value;

    /**
     * Creates an instance of TagCount class.
     */
    public TagCount() {
    }

    /**
     * Get the type property: Type of count.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of count.
     * 
     * @param type the type value to set.
     * @return the TagCount object itself.
     */
    public TagCount withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: Value of count.
     * 
     * @return the value value.
     */
    public Integer value() {
        return this.value;
    }

    /**
     * Set the value property: Value of count.
     * 
     * @param value the value value to set.
     * @return the TagCount object itself.
     */
    public TagCount withValue(Integer value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagCount from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagCount if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the TagCount.
     */
    public static TagCount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagCount deserializedTagCount = new TagCount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedTagCount.type = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedTagCount.value = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagCount;
        });
    }
}
