/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PolicyDefinitionGroup
implements JsonSerializable<PolicyDefinitionGroup> {
    private String name;
    private String displayName;
    private String category;
    private String description;
    private String additionalMetadataId;
    private static final ClientLogger LOGGER = new ClientLogger(PolicyDefinitionGroup.class);

    public String name() {
        return this.name;
    }

    public PolicyDefinitionGroup withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public PolicyDefinitionGroup withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String category() {
        return this.category;
    }

    public PolicyDefinitionGroup withCategory(String category) {
        this.category = category;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicyDefinitionGroup withDescription(String description) {
        this.description = description;
        return this;
    }

    public String additionalMetadataId() {
        return this.additionalMetadataId;
    }

    public PolicyDefinitionGroup withAdditionalMetadataId(String additionalMetadataId) {
        this.additionalMetadataId = additionalMetadataId;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model PolicyDefinitionGroup"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("additionalMetadataId", this.additionalMetadataId);
        return jsonWriter.writeEndObject();
    }

    public static PolicyDefinitionGroup fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyDefinitionGroup)jsonReader.readObject(reader -> {
            PolicyDefinitionGroup deserializedPolicyDefinitionGroup = new PolicyDefinitionGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPolicyDefinitionGroup.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedPolicyDefinitionGroup.displayName = reader.getString();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedPolicyDefinitionGroup.category = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPolicyDefinitionGroup.description = reader.getString();
                    continue;
                }
                if ("additionalMetadataId".equals(fieldName)) {
                    deserializedPolicyDefinitionGroup.additionalMetadataId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyDefinitionGroup;
        });
    }
}

