// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluent.models.DeploymentStackInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentStackTemplateDefinitionInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentStackValidateResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.models.UnmanageActionManagementGroupMode;
import com.azure.resourcemanager.resources.models.UnmanageActionResourceGroupMode;
import com.azure.resourcemanager.resources.models.UnmanageActionResourceMode;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DeploymentStacksClient.
 */
public interface DeploymentStacksClient extends InnerSupportsGet<DeploymentStackInner>,
    InnerSupportsListing<DeploymentStackInner>, InnerSupportsDelete<Void> {
    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentStackInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentStackInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentStackInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentStackInner> listAsync();

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentStackInner> list();

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentStackInner> list(Context context);

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentStackInner> listAtManagementGroupAsync(String managementGroupId);

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentStackInner> listAtManagementGroup(String managementGroupId);

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentStackInner> listAtManagementGroup(String managementGroupId, Context context);

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroupAsync(
        String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroup(
        String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroup(
        String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context);

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackInner> createOrUpdateAtResourceGroupAsync(String resourceGroupName, String deploymentStackName,
        DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner createOrUpdateAtResourceGroup(String resourceGroupName, String deploymentStackName,
        DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner createOrUpdateAtResourceGroup(String resourceGroupName, String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context);

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentStackInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName);

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackInner> getByResourceGroupAsync(String resourceGroupName, String deploymentStackName);

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentStackInner> getByResourceGroupWithResponse(String resourceGroupName, String deploymentStackName,
        Context context);

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner getByResourceGroup(String resourceGroupName, String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context);

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionWithResponseAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner>
        beginCreateOrUpdateAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner>
        beginCreateOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtSubscription(
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context);

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackInner> createOrUpdateAtSubscriptionAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner createOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner createOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack,
        Context context);

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentStackInner>> getAtSubscriptionWithResponseAsync(String deploymentStackName);

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackInner> getAtSubscriptionAsync(String deploymentStackName);

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentStackInner> getAtSubscriptionWithResponse(String deploymentStackName, Context context);

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner getAtSubscription(String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionWithResponseAsync(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionAsync(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionAsync(String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscription(String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscription(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtSubscriptionAsync(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtSubscriptionAsync(String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtSubscription(String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtSubscription(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context);

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroupAsync(
        String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroup(
        String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroup(
        String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context);

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackInner> createOrUpdateAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner createOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName,
        DeploymentStackInner deploymentStack);

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner createOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context);

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentStackInner>> getAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName);

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackInner> getAtManagementGroupAsync(String managementGroupId, String deploymentStackName);

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentStackInner> getAtManagementGroupWithResponse(String managementGroupId,
        String deploymentStackName, Context context);

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackInner getAtManagementGroup(String managementGroupId, String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroup(String managementGroupId,
        String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroup(String managementGroupId,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtManagementGroup(String managementGroupId, String deploymentStackName);

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtManagementGroup(String managementGroupId, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context);

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentStackTemplateDefinitionInner>>
        exportTemplateAtResourceGroupWithResponseAsync(String resourceGroupName, String deploymentStackName);

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtResourceGroupAsync(String resourceGroupName,
        String deploymentStackName);

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtResourceGroupWithResponse(String resourceGroupName,
        String deploymentStackName, Context context);

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackTemplateDefinitionInner exportTemplateAtResourceGroup(String resourceGroupName,
        String deploymentStackName);

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentStackTemplateDefinitionInner>>
        exportTemplateAtSubscriptionWithResponseAsync(String deploymentStackName);

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtSubscriptionAsync(String deploymentStackName);

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentStackTemplateDefinitionInner>
        exportTemplateAtSubscriptionWithResponse(String deploymentStackName, Context context);

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackTemplateDefinitionInner exportTemplateAtSubscription(String deploymentStackName);

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentStackTemplateDefinitionInner>>
        exportTemplateAtManagementGroupWithResponseAsync(String managementGroupId, String deploymentStackName);

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName);

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtManagementGroupWithResponse(
        String managementGroupId, String deploymentStackName, Context context);

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackTemplateDefinitionInner exportTemplateAtManagementGroup(String managementGroupId,
        String deploymentStackName);

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateStackAtResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtResourceGroupAsync(String resourceGroupName, String deploymentStackName,
            DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtResourceGroup(String resourceGroupName, String deploymentStackName,
            DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtResourceGroup(String resourceGroupName, String deploymentStackName,
            DeploymentStackInner deploymentStack, Context context);

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackValidateResultInner> validateStackAtResourceGroupAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackValidateResultInner validateStackAtResourceGroup(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackValidateResultInner validateStackAtResourceGroup(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context);

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateStackAtSubscriptionWithResponseAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack,
            Context context);

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackValidateResultInner> validateStackAtSubscriptionAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackValidateResultInner validateStackAtSubscription(String deploymentStackName,
        DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackValidateResultInner validateStackAtSubscription(String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context);

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateStackAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtManagementGroupAsync(String managementGroupId, String deploymentStackName,
            DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtManagementGroup(String managementGroupId, String deploymentStackName,
            DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtManagementGroup(String managementGroupId, String deploymentStackName,
            DeploymentStackInner deploymentStack, Context context);

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentStackValidateResultInner> validateStackAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackValidateResultInner validateStackAtManagementGroup(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack);

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentStackValidateResultInner validateStackAtManagementGroup(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context);
}
