// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DataManifestCustomResourceFunctionDefinition;
import java.io.IOException;
import java.util.List;

/**
 * The resource functions supported by a manifest.
 */
@Fluent
public final class DataManifestResourceFunctionsDefinition
    implements JsonSerializable<DataManifestResourceFunctionsDefinition> {
    /*
     * The standard resource functions (subscription and/or resourceGroup).
     */
    private List<String> standard;

    /*
     * An array of data manifest custom resource definition.
     */
    private List<DataManifestCustomResourceFunctionDefinition> custom;

    /**
     * Creates an instance of DataManifestResourceFunctionsDefinition class.
     */
    public DataManifestResourceFunctionsDefinition() {
    }

    /**
     * Get the standard property: The standard resource functions (subscription and/or resourceGroup).
     * 
     * @return the standard value.
     */
    public List<String> standard() {
        return this.standard;
    }

    /**
     * Set the standard property: The standard resource functions (subscription and/or resourceGroup).
     * 
     * @param standard the standard value to set.
     * @return the DataManifestResourceFunctionsDefinition object itself.
     */
    public DataManifestResourceFunctionsDefinition withStandard(List<String> standard) {
        this.standard = standard;
        return this;
    }

    /**
     * Get the custom property: An array of data manifest custom resource definition.
     * 
     * @return the custom value.
     */
    public List<DataManifestCustomResourceFunctionDefinition> custom() {
        return this.custom;
    }

    /**
     * Set the custom property: An array of data manifest custom resource definition.
     * 
     * @param custom the custom value to set.
     * @return the DataManifestResourceFunctionsDefinition object itself.
     */
    public DataManifestResourceFunctionsDefinition
        withCustom(List<DataManifestCustomResourceFunctionDefinition> custom) {
        this.custom = custom;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (custom() != null) {
            custom().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("standard", this.standard, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("custom", this.custom, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataManifestResourceFunctionsDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataManifestResourceFunctionsDefinition if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataManifestResourceFunctionsDefinition.
     */
    public static DataManifestResourceFunctionsDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataManifestResourceFunctionsDefinition deserializedDataManifestResourceFunctionsDefinition
                = new DataManifestResourceFunctionsDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("standard".equals(fieldName)) {
                    List<String> standard = reader.readArray(reader1 -> reader1.getString());
                    deserializedDataManifestResourceFunctionsDefinition.standard = standard;
                } else if ("custom".equals(fieldName)) {
                    List<DataManifestCustomResourceFunctionDefinition> custom
                        = reader.readArray(reader1 -> DataManifestCustomResourceFunctionDefinition.fromJson(reader1));
                    deserializedDataManifestResourceFunctionsDefinition.custom = custom;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataManifestResourceFunctionsDefinition;
        });
    }
}
