// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The deployment export result.
 */
@Fluent
public final class DeploymentExportResultInner implements JsonSerializable<DeploymentExportResultInner> {
    /*
     * The template content.
     */
    private Object template;

    /**
     * Creates an instance of DeploymentExportResultInner class.
     */
    public DeploymentExportResultInner() {
    }

    /**
     * Get the template property: The template content.
     * 
     * @return the template value.
     */
    public Object template() {
        return this.template;
    }

    /**
     * Set the template property: The template content.
     * 
     * @param template the template value to set.
     * @return the DeploymentExportResultInner object itself.
     */
    public DeploymentExportResultInner withTemplate(Object template) {
        this.template = template;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.template != null) {
            jsonWriter.writeUntypedField("template", this.template);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentExportResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentExportResultInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentExportResultInner.
     */
    public static DeploymentExportResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentExportResultInner deserializedDeploymentExportResultInner = new DeploymentExportResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("template".equals(fieldName)) {
                    deserializedDeploymentExportResultInner.template = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentExportResultInner;
        });
    }
}
