// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ActionOnUnmanage;
import com.azure.resourcemanager.resources.models.DenySettings;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.DeploymentStackProvisioningState;
import com.azure.resourcemanager.resources.models.DeploymentStacksDebugSetting;
import com.azure.resourcemanager.resources.models.DeploymentStacksParametersLink;
import com.azure.resourcemanager.resources.models.DeploymentStacksTemplateLink;
import com.azure.resourcemanager.resources.models.ManagedResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.ResourceReferenceExtended;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Deployment stack properties.
 */
@Fluent
public final class DeploymentStackProperties implements JsonSerializable<DeploymentStackProperties> {
    /*
     * The template content. You use this element when you want to pass the template syntax directly in the request
     * rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the
     * templateLink property or the template property, but not both.
     */
    private Object template;

    /*
     * The URI of the template. Use either the templateLink property or the template property, but not both.
     */
    private DeploymentStacksTemplateLink templateLink;

    /*
     * Name and value pairs that define the deployment parameters for the template. Use this element when providing the
     * parameter values directly in the request, rather than linking to an existing parameter file. Use either the
     * parametersLink property or the parameters property, but not both.
     */
    private Map<String, DeploymentParameter> parameters;

    /*
     * The URI of parameters file. Use this element to link to an existing parameters file. Use either the
     * parametersLink property or the parameters property, but not both.
     */
    private DeploymentStacksParametersLink parametersLink;

    /*
     * Defines the behavior of resources that are no longer managed after the Deployment stack is updated or deleted.
     */
    private ActionOnUnmanage actionOnUnmanage;

    /*
     * The debug setting of the deployment.
     */
    private DeploymentStacksDebugSetting debugSetting;

    /*
     * Flag to bypass service errors that indicate the stack resource list is not correctly synchronized.
     */
    private Boolean bypassStackOutOfSyncError;

    /*
     * The scope at which the initial deployment should be created. If a scope is not specified, it will default to the
     * scope of the deployment stack. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
     */
    private String deploymentScope;

    /*
     * Deployment stack description. Max length of 4096 characters.
     */
    private String description;

    /*
     * Defines how resources deployed by the stack are locked.
     */
    private DenySettings denySettings;

    /*
     * State of the deployment stack.
     */
    private DeploymentStackProvisioningState provisioningState;

    /*
     * The correlation id of the last Deployment stack upsert or delete operation. It is in GUID format and is used for
     * tracing.
     */
    private String correlationId;

    /*
     * An array of resources that were detached during the most recent Deployment stack update. Detached means that the
     * resource was removed from the template, but no relevant deletion operations were specified. So, the resource
     * still exists while no longer being associated with the stack.
     */
    private List<ResourceReference> detachedResources;

    /*
     * An array of resources that were deleted during the most recent Deployment stack update. Deleted means that the
     * resource was removed from the template and relevant deletion operations were specified.
     */
    private List<ResourceReference> deletedResources;

    /*
     * An array of resources that failed to reach goal state during the most recent update. Each resourceId is
     * accompanied by an error message.
     */
    private List<ResourceReferenceExtended> failedResources;

    /*
     * An array of resources currently managed by the deployment stack.
     */
    private List<ManagedResourceReference> resources;

    /*
     * The resourceId of the deployment resource created by the deployment stack.
     */
    private String deploymentId;

    /*
     * The outputs of the deployment resource created by the deployment stack.
     */
    private Object outputs;

    /*
     * The duration of the last successful Deployment stack update.
     */
    private String duration;

    /*
     * The error detail.
     */
    private ManagementError error;

    /**
     * Creates an instance of DeploymentStackProperties class.
     */
    public DeploymentStackProperties() {
    }

    /**
     * Get the template property: The template content. You use this element when you want to pass the template syntax
     * directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string.
     * Use either the templateLink property or the template property, but not both.
     * 
     * @return the template value.
     */
    public Object template() {
        return this.template;
    }

    /**
     * Set the template property: The template content. You use this element when you want to pass the template syntax
     * directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string.
     * Use either the templateLink property or the template property, but not both.
     * 
     * @param template the template value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withTemplate(Object template) {
        this.template = template;
        return this;
    }

    /**
     * Get the templateLink property: The URI of the template. Use either the templateLink property or the template
     * property, but not both.
     * 
     * @return the templateLink value.
     */
    public DeploymentStacksTemplateLink templateLink() {
        return this.templateLink;
    }

    /**
     * Set the templateLink property: The URI of the template. Use either the templateLink property or the template
     * property, but not both.
     * 
     * @param templateLink the templateLink value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withTemplateLink(DeploymentStacksTemplateLink templateLink) {
        this.templateLink = templateLink;
        return this;
    }

    /**
     * Get the parameters property: Name and value pairs that define the deployment parameters for the template. Use
     * this element when providing the parameter values directly in the request, rather than linking to an existing
     * parameter file. Use either the parametersLink property or the parameters property, but not both.
     * 
     * @return the parameters value.
     */
    public Map<String, DeploymentParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Name and value pairs that define the deployment parameters for the template. Use
     * this element when providing the parameter values directly in the request, rather than linking to an existing
     * parameter file. Use either the parametersLink property or the parameters property, but not both.
     * 
     * @param parameters the parameters value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withParameters(Map<String, DeploymentParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the parametersLink property: The URI of parameters file. Use this element to link to an existing parameters
     * file. Use either the parametersLink property or the parameters property, but not both.
     * 
     * @return the parametersLink value.
     */
    public DeploymentStacksParametersLink parametersLink() {
        return this.parametersLink;
    }

    /**
     * Set the parametersLink property: The URI of parameters file. Use this element to link to an existing parameters
     * file. Use either the parametersLink property or the parameters property, but not both.
     * 
     * @param parametersLink the parametersLink value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withParametersLink(DeploymentStacksParametersLink parametersLink) {
        this.parametersLink = parametersLink;
        return this;
    }

    /**
     * Get the actionOnUnmanage property: Defines the behavior of resources that are no longer managed after the
     * Deployment stack is updated or deleted.
     * 
     * @return the actionOnUnmanage value.
     */
    public ActionOnUnmanage actionOnUnmanage() {
        return this.actionOnUnmanage;
    }

    /**
     * Set the actionOnUnmanage property: Defines the behavior of resources that are no longer managed after the
     * Deployment stack is updated or deleted.
     * 
     * @param actionOnUnmanage the actionOnUnmanage value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withActionOnUnmanage(ActionOnUnmanage actionOnUnmanage) {
        this.actionOnUnmanage = actionOnUnmanage;
        return this;
    }

    /**
     * Get the debugSetting property: The debug setting of the deployment.
     * 
     * @return the debugSetting value.
     */
    public DeploymentStacksDebugSetting debugSetting() {
        return this.debugSetting;
    }

    /**
     * Set the debugSetting property: The debug setting of the deployment.
     * 
     * @param debugSetting the debugSetting value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withDebugSetting(DeploymentStacksDebugSetting debugSetting) {
        this.debugSetting = debugSetting;
        return this;
    }

    /**
     * Get the bypassStackOutOfSyncError property: Flag to bypass service errors that indicate the stack resource list
     * is not correctly synchronized.
     * 
     * @return the bypassStackOutOfSyncError value.
     */
    public Boolean bypassStackOutOfSyncError() {
        return this.bypassStackOutOfSyncError;
    }

    /**
     * Set the bypassStackOutOfSyncError property: Flag to bypass service errors that indicate the stack resource list
     * is not correctly synchronized.
     * 
     * @param bypassStackOutOfSyncError the bypassStackOutOfSyncError value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withBypassStackOutOfSyncError(Boolean bypassStackOutOfSyncError) {
        this.bypassStackOutOfSyncError = bypassStackOutOfSyncError;
        return this;
    }

    /**
     * Get the deploymentScope property: The scope at which the initial deployment should be created. If a scope is not
     * specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
     * 
     * @return the deploymentScope value.
     */
    public String deploymentScope() {
        return this.deploymentScope;
    }

    /**
     * Set the deploymentScope property: The scope at which the initial deployment should be created. If a scope is not
     * specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format:
     * '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     * '/subscriptions/{subscriptionId}'), resource group (format:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
     * 
     * @param deploymentScope the deploymentScope value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withDeploymentScope(String deploymentScope) {
        this.deploymentScope = deploymentScope;
        return this;
    }

    /**
     * Get the description property: Deployment stack description. Max length of 4096 characters.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Deployment stack description. Max length of 4096 characters.
     * 
     * @param description the description value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the denySettings property: Defines how resources deployed by the stack are locked.
     * 
     * @return the denySettings value.
     */
    public DenySettings denySettings() {
        return this.denySettings;
    }

    /**
     * Set the denySettings property: Defines how resources deployed by the stack are locked.
     * 
     * @param denySettings the denySettings value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withDenySettings(DenySettings denySettings) {
        this.denySettings = denySettings;
        return this;
    }

    /**
     * Get the provisioningState property: State of the deployment stack.
     * 
     * @return the provisioningState value.
     */
    public DeploymentStackProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the correlationId property: The correlation id of the last Deployment stack upsert or delete operation. It is
     * in GUID format and is used for tracing.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Get the detachedResources property: An array of resources that were detached during the most recent Deployment
     * stack update. Detached means that the resource was removed from the template, but no relevant deletion operations
     * were specified. So, the resource still exists while no longer being associated with the stack.
     * 
     * @return the detachedResources value.
     */
    public List<ResourceReference> detachedResources() {
        return this.detachedResources;
    }

    /**
     * Get the deletedResources property: An array of resources that were deleted during the most recent Deployment
     * stack update. Deleted means that the resource was removed from the template and relevant deletion operations were
     * specified.
     * 
     * @return the deletedResources value.
     */
    public List<ResourceReference> deletedResources() {
        return this.deletedResources;
    }

    /**
     * Get the failedResources property: An array of resources that failed to reach goal state during the most recent
     * update. Each resourceId is accompanied by an error message.
     * 
     * @return the failedResources value.
     */
    public List<ResourceReferenceExtended> failedResources() {
        return this.failedResources;
    }

    /**
     * Get the resources property: An array of resources currently managed by the deployment stack.
     * 
     * @return the resources value.
     */
    public List<ManagedResourceReference> resources() {
        return this.resources;
    }

    /**
     * Get the deploymentId property: The resourceId of the deployment resource created by the deployment stack.
     * 
     * @return the deploymentId value.
     */
    public String deploymentId() {
        return this.deploymentId;
    }

    /**
     * Get the outputs property: The outputs of the deployment resource created by the deployment stack.
     * 
     * @return the outputs value.
     */
    public Object outputs() {
        return this.outputs;
    }

    /**
     * Get the duration property: The duration of the last successful Deployment stack update.
     * 
     * @return the duration value.
     */
    public String duration() {
        return this.duration;
    }

    /**
     * Get the error property: The error detail.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The error detail.
     * 
     * @param error the error value to set.
     * @return the DeploymentStackProperties object itself.
     */
    public DeploymentStackProperties withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (templateLink() != null) {
            templateLink().validate();
        }
        if (parameters() != null) {
            parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (parametersLink() != null) {
            parametersLink().validate();
        }
        if (actionOnUnmanage() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property actionOnUnmanage in model DeploymentStackProperties"));
        } else {
            actionOnUnmanage().validate();
        }
        if (debugSetting() != null) {
            debugSetting().validate();
        }
        if (denySettings() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property denySettings in model DeploymentStackProperties"));
        } else {
            denySettings().validate();
        }
        if (detachedResources() != null) {
            detachedResources().forEach(e -> e.validate());
        }
        if (deletedResources() != null) {
            deletedResources().forEach(e -> e.validate());
        }
        if (failedResources() != null) {
            failedResources().forEach(e -> e.validate());
        }
        if (resources() != null) {
            resources().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeploymentStackProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("actionOnUnmanage", this.actionOnUnmanage);
        jsonWriter.writeJsonField("denySettings", this.denySettings);
        if (this.template != null) {
            jsonWriter.writeUntypedField("template", this.template);
        }
        jsonWriter.writeJsonField("templateLink", this.templateLink);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("parametersLink", this.parametersLink);
        jsonWriter.writeJsonField("debugSetting", this.debugSetting);
        jsonWriter.writeBooleanField("bypassStackOutOfSyncError", this.bypassStackOutOfSyncError);
        jsonWriter.writeStringField("deploymentScope", this.deploymentScope);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentStackProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentStackProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeploymentStackProperties.
     */
    public static DeploymentStackProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentStackProperties deserializedDeploymentStackProperties = new DeploymentStackProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionOnUnmanage".equals(fieldName)) {
                    deserializedDeploymentStackProperties.actionOnUnmanage = ActionOnUnmanage.fromJson(reader);
                } else if ("denySettings".equals(fieldName)) {
                    deserializedDeploymentStackProperties.denySettings = DenySettings.fromJson(reader);
                } else if ("template".equals(fieldName)) {
                    deserializedDeploymentStackProperties.template = reader.readUntyped();
                } else if ("templateLink".equals(fieldName)) {
                    deserializedDeploymentStackProperties.templateLink = DeploymentStacksTemplateLink.fromJson(reader);
                } else if ("parameters".equals(fieldName)) {
                    Map<String, DeploymentParameter> parameters
                        = reader.readMap(reader1 -> DeploymentParameter.fromJson(reader1));
                    deserializedDeploymentStackProperties.parameters = parameters;
                } else if ("parametersLink".equals(fieldName)) {
                    deserializedDeploymentStackProperties.parametersLink
                        = DeploymentStacksParametersLink.fromJson(reader);
                } else if ("debugSetting".equals(fieldName)) {
                    deserializedDeploymentStackProperties.debugSetting = DeploymentStacksDebugSetting.fromJson(reader);
                } else if ("bypassStackOutOfSyncError".equals(fieldName)) {
                    deserializedDeploymentStackProperties.bypassStackOutOfSyncError
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("deploymentScope".equals(fieldName)) {
                    deserializedDeploymentStackProperties.deploymentScope = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedDeploymentStackProperties.description = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedDeploymentStackProperties.provisioningState
                        = DeploymentStackProvisioningState.fromString(reader.getString());
                } else if ("correlationId".equals(fieldName)) {
                    deserializedDeploymentStackProperties.correlationId = reader.getString();
                } else if ("detachedResources".equals(fieldName)) {
                    List<ResourceReference> detachedResources
                        = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedDeploymentStackProperties.detachedResources = detachedResources;
                } else if ("deletedResources".equals(fieldName)) {
                    List<ResourceReference> deletedResources
                        = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedDeploymentStackProperties.deletedResources = deletedResources;
                } else if ("failedResources".equals(fieldName)) {
                    List<ResourceReferenceExtended> failedResources
                        = reader.readArray(reader1 -> ResourceReferenceExtended.fromJson(reader1));
                    deserializedDeploymentStackProperties.failedResources = failedResources;
                } else if ("resources".equals(fieldName)) {
                    List<ManagedResourceReference> resources
                        = reader.readArray(reader1 -> ManagedResourceReference.fromJson(reader1));
                    deserializedDeploymentStackProperties.resources = resources;
                } else if ("deploymentId".equals(fieldName)) {
                    deserializedDeploymentStackProperties.deploymentId = reader.getString();
                } else if ("outputs".equals(fieldName)) {
                    deserializedDeploymentStackProperties.outputs = reader.readUntyped();
                } else if ("duration".equals(fieldName)) {
                    deserializedDeploymentStackProperties.duration = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedDeploymentStackProperties.error = ManagementError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentStackProperties;
        });
    }
}
