// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ParameterDefinitionsValue;
import com.azure.resourcemanager.resources.models.PolicyType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The policy definition properties.
 */
@Fluent
public final class PolicyDefinitionProperties implements JsonSerializable<PolicyDefinitionProperties> {
    /*
     * The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    private PolicyType policyType;

    /*
     * The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     */
    private String mode;

    /*
     * The display name of the policy definition.
     */
    private String displayName;

    /*
     * The policy definition description.
     */
    private String description;

    /*
     * The policy rule.
     */
    private Object policyRule;

    /*
     * The policy definition metadata. Metadata is an open ended object and is typically a collection of key value
     * pairs.
     */
    private Object metadata;

    /*
     * The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    private Map<String, ParameterDefinitionsValue> parameters;

    /*
     * The policy definition version in #.#.# format.
     */
    private String version;

    /*
     * A list of available versions for this policy definition.
     */
    private List<String> versions;

    /**
     * Creates an instance of PolicyDefinitionProperties class.
     */
    public PolicyDefinitionProperties() {
    }

    /**
     * Get the policyType property: The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom,
     * and Static.
     * 
     * @return the policyType value.
     */
    public PolicyType policyType() {
        return this.policyType;
    }

    /**
     * Set the policyType property: The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom,
     * and Static.
     * 
     * @param policyType the policyType value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withPolicyType(PolicyType policyType) {
        this.policyType = policyType;
        return this;
    }

    /**
     * Get the mode property: The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     * 
     * @return the mode value.
     */
    public String mode() {
        return this.mode;
    }

    /**
     * Set the mode property: The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     * 
     * @param mode the mode value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withMode(String mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the displayName property: The display name of the policy definition.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the policy definition.
     * 
     * @param displayName the displayName value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The policy definition description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The policy definition description.
     * 
     * @param description the description value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the policyRule property: The policy rule.
     * 
     * @return the policyRule value.
     */
    public Object policyRule() {
        return this.policyRule;
    }

    /**
     * Set the policyRule property: The policy rule.
     * 
     * @param policyRule the policyRule value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withPolicyRule(Object policyRule) {
        this.policyRule = policyRule;
        return this;
    }

    /**
     * Get the metadata property: The policy definition metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @return the metadata value.
     */
    public Object metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The policy definition metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @param metadata the metadata value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the parameters property: The parameter definitions for parameters used in the policy rule. The keys are the
     * parameter names.
     * 
     * @return the parameters value.
     */
    public Map<String, ParameterDefinitionsValue> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameter definitions for parameters used in the policy rule. The keys are the
     * parameter names.
     * 
     * @param parameters the parameters value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withParameters(Map<String, ParameterDefinitionsValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the version property: The policy definition version in #.#.# format.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: The policy definition version in #.#.# format.
     * 
     * @param version the version value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the versions property: A list of available versions for this policy definition.
     * 
     * @return the versions value.
     */
    public List<String> versions() {
        return this.versions;
    }

    /**
     * Set the versions property: A list of available versions for this policy definition.
     * 
     * @param versions the versions value to set.
     * @return the PolicyDefinitionProperties object itself.
     */
    public PolicyDefinitionProperties withVersions(List<String> versions) {
        this.versions = versions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (parameters() != null) {
            parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyType", this.policyType == null ? null : this.policyType.toString());
        jsonWriter.writeStringField("mode", this.mode);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        if (this.policyRule != null) {
            jsonWriter.writeUntypedField("policyRule", this.policyRule);
        }
        if (this.metadata != null) {
            jsonWriter.writeUntypedField("metadata", this.metadata);
        }
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeArrayField("versions", this.versions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyDefinitionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyDefinitionProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyDefinitionProperties.
     */
    public static PolicyDefinitionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyDefinitionProperties deserializedPolicyDefinitionProperties = new PolicyDefinitionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("policyType".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.policyType = PolicyType.fromString(reader.getString());
                } else if ("mode".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.mode = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.description = reader.getString();
                } else if ("policyRule".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.policyRule = reader.readUntyped();
                } else if ("metadata".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.metadata = reader.readUntyped();
                } else if ("parameters".equals(fieldName)) {
                    Map<String, ParameterDefinitionsValue> parameters
                        = reader.readMap(reader1 -> ParameterDefinitionsValue.fromJson(reader1));
                    deserializedPolicyDefinitionProperties.parameters = parameters;
                } else if ("version".equals(fieldName)) {
                    deserializedPolicyDefinitionProperties.version = reader.getString();
                } else if ("versions".equals(fieldName)) {
                    List<String> versions = reader.readArray(reader1 -> reader1.getString());
                    deserializedPolicyDefinitionProperties.versions = versions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyDefinitionProperties;
        });
    }
}
