// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluent.DeploymentStacksClient;
import com.azure.resourcemanager.resources.fluent.models.DeploymentStackInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentStackTemplateDefinitionInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentStackValidateResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.models.DeploymentStackListResult;
import com.azure.resourcemanager.resources.models.UnmanageActionManagementGroupMode;
import com.azure.resourcemanager.resources.models.UnmanageActionResourceGroupMode;
import com.azure.resourcemanager.resources.models.UnmanageActionResourceMode;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DeploymentStacksClient.
 */
public final class DeploymentStacksClientImpl implements InnerSupportsGet<DeploymentStackInner>,
    InnerSupportsListing<DeploymentStackInner>, InnerSupportsDelete<Void>, DeploymentStacksClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DeploymentStacksService service;

    /**
     * The service client containing this operation class.
     */
    private final DeploymentStacksManagementClientImpl client;

    /**
     * Initializes an instance of DeploymentStacksClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    DeploymentStacksClientImpl(DeploymentStacksManagementClientImpl client) {
        this.service
            = RestProxy.create(DeploymentStacksService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for DeploymentStacksManagementClientDeploymentStacks to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "DeploymentStacksMana")
    public interface DeploymentStacksService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackListResult>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackListResult>> listAtManagementGroup(@HostParam("$host") String endpoint,
            @PathParam("managementGroupId") String managementGroupId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentStackInner deploymentStack, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentStackName") String deploymentStackName,
            @QueryParam("unmanageAction.Resources") UnmanageActionResourceMode unmanageActionResources,
            @QueryParam("unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode unmanageActionResourceGroups,
            @QueryParam("unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode unmanageActionManagementGroups,
            @QueryParam("bypassStackOutOfSyncError") Boolean bypassStackOutOfSyncError,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscription(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentStackInner deploymentStack, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackInner>> getAtSubscription(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteAtSubscription(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("deploymentStackName") String deploymentStackName,
            @QueryParam("unmanageAction.Resources") UnmanageActionResourceMode unmanageActionResources,
            @QueryParam("unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode unmanageActionResourceGroups,
            @QueryParam("unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode unmanageActionManagementGroups,
            @QueryParam("bypassStackOutOfSyncError") Boolean bypassStackOutOfSyncError,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroup(@HostParam("$host") String endpoint,
            @PathParam("managementGroupId") String managementGroupId,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentStackInner deploymentStack, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackInner>> getAtManagementGroup(@HostParam("$host") String endpoint,
            @PathParam("managementGroupId") String managementGroupId,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroup(@HostParam("$host") String endpoint,
            @PathParam("managementGroupId") String managementGroupId,
            @PathParam("deploymentStackName") String deploymentStackName,
            @QueryParam("unmanageAction.Resources") UnmanageActionResourceMode unmanageActionResources,
            @QueryParam("unmanageAction.ResourceGroups") UnmanageActionResourceGroupMode unmanageActionResourceGroups,
            @QueryParam("unmanageAction.ManagementGroups") UnmanageActionManagementGroupMode unmanageActionManagementGroups,
            @QueryParam("bypassStackOutOfSyncError") Boolean bypassStackOutOfSyncError,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtResourceGroup(
            @HostParam("$host") String endpoint, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtSubscription(
            @HostParam("$host") String endpoint, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/exportTemplate")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtManagementGroup(
            @HostParam("$host") String endpoint, @PathParam("managementGroupId") String managementGroupId,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses({ 200, 202, 400 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validateStackAtResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentStackInner deploymentStack, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses({ 200, 202, 400 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validateStackAtSubscription(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentStackInner deploymentStack, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}/validate")
        @ExpectedResponses({ 200, 202, 400 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> validateStackAtManagementGroup(@HostParam("$host") String endpoint,
            @PathParam("managementGroupId") String managementGroupId,
            @PathParam("deploymentStackName") String deploymentStackName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DeploymentStackInner deploymentStack, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackListResult>> listAtResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackListResult>> listAtSubscriptionNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DeploymentStackListResult>> listAtManagementGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<DeploymentStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentStackInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> listAtResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentStackInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listAtResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Lists all the Deployment stacks within the specified Resource Group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<DeploymentStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentStackInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(),
            nextLink -> listAtSubscriptionNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentStackInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context),
            nextLink -> listAtSubscriptionNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Lists all the Deployment stacks within the specified Subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtManagementGroupSinglePageAsync(String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAtManagementGroup(this.client.getEndpoint(), managementGroupId,
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<DeploymentStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtManagementGroupSinglePageAsync(String managementGroupId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listAtManagementGroup(this.client.getEndpoint(), managementGroupId, this.client.getApiVersion(), accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeploymentStackInner> listAtManagementGroupAsync(String managementGroupId) {
        return new PagedFlux<>(() -> listAtManagementGroupSinglePageAsync(managementGroupId),
            nextLink -> listAtManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DeploymentStackInner> listAtManagementGroupAsync(String managementGroupId, Context context) {
        return new PagedFlux<>(() -> listAtManagementGroupSinglePageAsync(managementGroupId, context),
            nextLink -> listAtManagementGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> listAtManagementGroup(String managementGroupId) {
        return new PagedIterable<>(listAtManagementGroupAsync(managementGroupId));
    }

    /**
     * Lists all the Deployment stacks within the specified Management Group.
     * 
     * @param managementGroupId Management Group id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeploymentStackInner> listAtManagementGroup(String managementGroupId, Context context) {
        return new PagedIterable<>(listAtManagementGroupAsync(managementGroupId, context));
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateAtResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(),
                deploymentStack, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, deploymentStackName, this.client.getApiVersion(), deploymentStack, accept, context);
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroupAsync(
        String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName, deploymentStack);
        return this.client.<DeploymentStackInner, DeploymentStackInner>getLroResult(mono, this.client.getHttpPipeline(),
            DeploymentStackInner.class, DeploymentStackInner.class, this.client.getContext());
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroupAsync(
        String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateAtResourceGroupWithResponseAsync(resourceGroupName,
            deploymentStackName, deploymentStack, context);
        return this.client.<DeploymentStackInner, DeploymentStackInner>getLroResult(mono, this.client.getHttpPipeline(),
            DeploymentStackInner.class, DeploymentStackInner.class, context);
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroup(
        String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack)
            .getSyncPoller();
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtResourceGroup(
        String resourceGroupName, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return this
            .beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack, context)
            .getSyncPoller();
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackInner> createOrUpdateAtResourceGroupAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        return beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentStackInner> createOrUpdateAtResourceGroupAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return beginCreateOrUpdateAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtResourceGroup(String resourceGroupName, String deploymentStackName,
        DeploymentStackInner deploymentStack) {
        return createOrUpdateAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack).block();
    }

    /**
     * Creates or updates a Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtResourceGroup(String resourceGroupName, String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context) {
        return createOrUpdateAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack, context)
            .block();
    }

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentStackInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, deploymentStackName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentStackInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            deploymentStackName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackInner> getByResourceGroupAsync(String resourceGroupName, String deploymentStackName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentStackInner> getByResourceGroupWithResponse(String resourceGroupName,
        String deploymentStackName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName, context).block();
    }

    /**
     * Gets a Deployment stack with a given name at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Resource Group scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner getByResourceGroup(String resourceGroupName, String deploymentStackName) {
        return getByResourceGroupWithResponse(resourceGroupName, deploymentStackName, Context.NONE).getValue();
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
                unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups,
            bypassStackOutOfSyncError, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        return this
            .beginDeleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError)
            .getSyncPoller();
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        return this
            .beginDeleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context)
            .getSyncPoller();
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        return beginDeleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        return beginDeleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        return beginDeleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        deleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
            unmanageActionManagementGroups, bypassStackOutOfSyncError).block();
    }

    /**
     * Deletes a Deployment stack by name at Resource Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        deleteAsync(resourceGroupName, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
            unmanageActionManagementGroups, bypassStackOutOfSyncError, context).block();
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionWithResponseAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateAtSubscription(this.client.getEndpoint(),
                this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), deploymentStack,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtSubscriptionWithResponseAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(),
            deploymentStackName, this.client.getApiVersion(), deploymentStack, accept, context);
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner>
        beginCreateOrUpdateAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtSubscriptionWithResponseAsync(deploymentStackName, deploymentStack);
        return this.client.<DeploymentStackInner, DeploymentStackInner>getLroResult(mono, this.client.getHttpPipeline(),
            DeploymentStackInner.class, DeploymentStackInner.class, this.client.getContext());
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtSubscriptionAsync(
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtSubscriptionWithResponseAsync(deploymentStackName, deploymentStack, context);
        return this.client.<DeploymentStackInner, DeploymentStackInner>getLroResult(mono, this.client.getHttpPipeline(),
            DeploymentStackInner.class, DeploymentStackInner.class, context);
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner>
        beginCreateOrUpdateAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginCreateOrUpdateAtSubscriptionAsync(deploymentStackName, deploymentStack).getSyncPoller();
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtSubscription(
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return this.beginCreateOrUpdateAtSubscriptionAsync(deploymentStackName, deploymentStack, context)
            .getSyncPoller();
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackInner> createOrUpdateAtSubscriptionAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack) {
        return beginCreateOrUpdateAtSubscriptionAsync(deploymentStackName, deploymentStack).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentStackInner> createOrUpdateAtSubscriptionAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context) {
        return beginCreateOrUpdateAtSubscriptionAsync(deploymentStackName, deploymentStack, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtSubscription(String deploymentStackName,
        DeploymentStackInner deploymentStack) {
        return createOrUpdateAtSubscriptionAsync(deploymentStackName, deploymentStack).block();
    }

    /**
     * Creates or updates a Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtSubscription(String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context) {
        return createOrUpdateAtSubscriptionAsync(deploymentStackName, deploymentStack, context).block();
    }

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentStackInner>> getAtSubscriptionWithResponseAsync(String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAtSubscription(this.client.getEndpoint(),
                this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentStackInner>> getAtSubscriptionWithResponseAsync(String deploymentStackName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(),
            deploymentStackName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackInner> getAtSubscriptionAsync(String deploymentStackName) {
        return getAtSubscriptionWithResponseAsync(deploymentStackName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentStackInner> getAtSubscriptionWithResponse(String deploymentStackName, Context context) {
        return getAtSubscriptionWithResponseAsync(deploymentStackName, context).block();
    }

    /**
     * Gets a Deployment stack with a given name at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Subscription scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner getAtSubscription(String deploymentStackName) {
        return getAtSubscriptionWithResponse(deploymentStackName, Context.NONE).getValue();
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionWithResponseAsync(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteAtSubscription(this.client.getEndpoint(),
            this.client.getSubscriptionId(), deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
            unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtSubscriptionWithResponseAsync(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(),
            deploymentStackName, unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups,
            bypassStackOutOfSyncError, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionAsync(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteAtSubscriptionWithResponseAsync(deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionAsync(String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteAtSubscriptionWithResponseAsync(deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtSubscriptionAsync(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteAtSubscriptionWithResponseAsync(deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscription(String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        return this
            .beginDeleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
                unmanageActionManagementGroups, bypassStackOutOfSyncError)
            .getSyncPoller();
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtSubscription(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        return this
            .beginDeleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
                unmanageActionManagementGroups, bypassStackOutOfSyncError, context)
            .getSyncPoller();
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtSubscriptionAsync(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        return beginDeleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtSubscriptionAsync(String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        return beginDeleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAtSubscriptionAsync(String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        return beginDeleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtSubscription(String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        deleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
            unmanageActionManagementGroups, bypassStackOutOfSyncError).block();
    }

    /**
     * Deletes a Deployment stack by name at Subscription scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtSubscription(String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        deleteAtSubscriptionAsync(deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
            unmanageActionManagementGroups, bypassStackOutOfSyncError, context).block();
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdateAtManagementGroup(this.client.getEndpoint(),
                managementGroupId, deploymentStackName, this.client.getApiVersion(), deploymentStack, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), managementGroupId,
            deploymentStackName, this.client.getApiVersion(), deploymentStack, accept, context);
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroupAsync(
        String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, deploymentStack);
        return this.client.<DeploymentStackInner, DeploymentStackInner>getLroResult(mono, this.client.getHttpPipeline(),
            DeploymentStackInner.class, DeploymentStackInner.class, this.client.getContext());
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackInner>, DeploymentStackInner>
        beginCreateOrUpdateAtManagementGroupAsync(String managementGroupId, String deploymentStackName,
            DeploymentStackInner deploymentStack, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateAtManagementGroupWithResponseAsync(managementGroupId,
            deploymentStackName, deploymentStack, context);
        return this.client.<DeploymentStackInner, DeploymentStackInner>getLroResult(mono, this.client.getHttpPipeline(),
            DeploymentStackInner.class, DeploymentStackInner.class, context);
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroup(
        String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginCreateOrUpdateAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack)
            .getSyncPoller();
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackInner>, DeploymentStackInner> beginCreateOrUpdateAtManagementGroup(
        String managementGroupId, String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return this
            .beginCreateOrUpdateAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack, context)
            .getSyncPoller();
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackInner> createOrUpdateAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        return beginCreateOrUpdateAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentStackInner> createOrUpdateAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return beginCreateOrUpdateAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName,
        DeploymentStackInner deploymentStack) {
        return createOrUpdateAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack).block();
    }

    /**
     * Creates or updates a Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deployment stack object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner createOrUpdateAtManagementGroup(String managementGroupId, String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context) {
        return createOrUpdateAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack, context)
            .block();
    }

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentStackInner>> getAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAtManagementGroup(this.client.getEndpoint(), managementGroupId,
                deploymentStackName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentStackInner>> getAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAtManagementGroup(this.client.getEndpoint(), managementGroupId, deploymentStackName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackInner> getAtManagementGroupAsync(String managementGroupId, String deploymentStackName) {
        return getAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentStackInner> getAtManagementGroupWithResponse(String managementGroupId,
        String deploymentStackName, Context context) {
        return getAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, context).block();
    }

    /**
     * Gets a Deployment stack with a given name at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deployment stack with a given name at Management Group scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackInner getAtManagementGroup(String managementGroupId, String deploymentStackName) {
        return getAtManagementGroupWithResponse(managementGroupId, deploymentStackName, Context.NONE).getValue();
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteAtManagementGroup(this.client.getEndpoint(),
            managementGroupId, deploymentStackName, unmanageActionResources, unmanageActionResourceGroups,
            unmanageActionManagementGroups, bypassStackOutOfSyncError, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAtManagementGroup(this.client.getEndpoint(), managementGroupId, deploymentStackName,
            unmanageActionResources, unmanageActionResourceGroups, unmanageActionManagementGroups,
            bypassStackOutOfSyncError, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroup(String managementGroupId,
        String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        return this
            .beginDeleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError)
            .getSyncPoller();
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteAtManagementGroup(String managementGroupId,
        String deploymentStackName, UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        return this
            .beginDeleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources,
                unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context)
            .getSyncPoller();
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError) {
        return beginDeleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        return beginDeleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAtManagementGroupAsync(String managementGroupId, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        return beginDeleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtManagementGroup(String managementGroupId, String deploymentStackName) {
        final UnmanageActionResourceMode unmanageActionResources = null;
        final UnmanageActionResourceGroupMode unmanageActionResourceGroups = null;
        final UnmanageActionManagementGroupMode unmanageActionManagementGroups = null;
        final Boolean bypassStackOutOfSyncError = null;
        deleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError).block();
    }

    /**
     * Deletes a Deployment stack by name at Management Group scope. When operation completes, status code 200 returned
     * without content.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param unmanageActionResources Flag to indicate delete rather than detach for unmanaged resources.
     * @param unmanageActionResourceGroups Flag to indicate delete rather than detach for unmanaged resource groups.
     * @param unmanageActionManagementGroups Flag to indicate delete rather than detach for unmanaged management groups.
     * @param bypassStackOutOfSyncError Flag to bypass service errors that indicate the stack resource list is not
     * correctly synchronized.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtManagementGroup(String managementGroupId, String deploymentStackName,
        UnmanageActionResourceMode unmanageActionResources,
        UnmanageActionResourceGroupMode unmanageActionResourceGroups,
        UnmanageActionManagementGroupMode unmanageActionManagementGroups, Boolean bypassStackOutOfSyncError,
        Context context) {
        deleteAtManagementGroupAsync(managementGroupId, deploymentStackName, unmanageActionResources,
            unmanageActionResourceGroups, unmanageActionManagementGroups, bypassStackOutOfSyncError, context).block();
    }

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentStackTemplateDefinitionInner>>
        exportTemplateAtResourceGroupWithResponseAsync(String resourceGroupName, String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.exportTemplateAtResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtResourceGroupWithResponseAsync(
        String resourceGroupName, String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.exportTemplateAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, deploymentStackName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtResourceGroupAsync(String resourceGroupName,
        String deploymentStackName) {
        return exportTemplateAtResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtResourceGroupWithResponse(
        String resourceGroupName, String deploymentStackName, Context context) {
        return exportTemplateAtResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName, context).block();
    }

    /**
     * Exports the template used to create the Deployment stack at Resource Group scope.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackTemplateDefinitionInner exportTemplateAtResourceGroup(String resourceGroupName,
        String deploymentStackName) {
        return exportTemplateAtResourceGroupWithResponse(resourceGroupName, deploymentStackName, Context.NONE)
            .getValue();
    }

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentStackTemplateDefinitionInner>>
        exportTemplateAtSubscriptionWithResponseAsync(String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.exportTemplateAtSubscription(this.client.getEndpoint(),
                this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentStackTemplateDefinitionInner>>
        exportTemplateAtSubscriptionWithResponseAsync(String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.exportTemplateAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(),
            deploymentStackName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtSubscriptionAsync(String deploymentStackName) {
        return exportTemplateAtSubscriptionWithResponseAsync(deploymentStackName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentStackTemplateDefinitionInner>
        exportTemplateAtSubscriptionWithResponse(String deploymentStackName, Context context) {
        return exportTemplateAtSubscriptionWithResponseAsync(deploymentStackName, context).block();
    }

    /**
     * Exports the template used to create the Deployment stack at Subscription scope.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackTemplateDefinitionInner exportTemplateAtSubscription(String deploymentStackName) {
        return exportTemplateAtSubscriptionWithResponse(deploymentStackName, Context.NONE).getValue();
    }

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeploymentStackTemplateDefinitionInner>>
        exportTemplateAtManagementGroupWithResponseAsync(String managementGroupId, String deploymentStackName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.exportTemplateAtManagementGroup(this.client.getEndpoint(),
                managementGroupId, deploymentStackName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DeploymentStackTemplateDefinitionInner>> exportTemplateAtManagementGroupWithResponseAsync(
        String managementGroupId, String deploymentStackName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.exportTemplateAtManagementGroup(this.client.getEndpoint(), managementGroupId,
            deploymentStackName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackTemplateDefinitionInner> exportTemplateAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName) {
        return exportTemplateAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeploymentStackTemplateDefinitionInner> exportTemplateAtManagementGroupWithResponse(
        String managementGroupId, String deploymentStackName, Context context) {
        return exportTemplateAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, context)
            .block();
    }

    /**
     * Exports the template used to create the Deployment stack at Management Group scope.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return export Template specific properties of the Deployment stack.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackTemplateDefinitionInner exportTemplateAtManagementGroup(String managementGroupId,
        String deploymentStackName) {
        return exportTemplateAtManagementGroupWithResponse(managementGroupId, deploymentStackName, Context.NONE)
            .getValue();
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateStackAtResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateStackAtResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, deploymentStackName, this.client.getApiVersion(),
                deploymentStack, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateStackAtResourceGroupWithResponseAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateStackAtResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, deploymentStackName, this.client.getApiVersion(), deploymentStack, accept, context);
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtResourceGroupAsync(String resourceGroupName, String deploymentStackName,
            DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateStackAtResourceGroupWithResponseAsync(resourceGroupName, deploymentStackName, deploymentStack);
        return this.client.<DeploymentStackValidateResultInner, DeploymentStackValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentStackValidateResultInner.class,
            DeploymentStackValidateResultInner.class, this.client.getContext());
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtResourceGroupAsync(String resourceGroupName, String deploymentStackName,
            DeploymentStackInner deploymentStack, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = validateStackAtResourceGroupWithResponseAsync(resourceGroupName,
            deploymentStackName, deploymentStack, context);
        return this.client.<DeploymentStackValidateResultInner, DeploymentStackValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentStackValidateResultInner.class,
            DeploymentStackValidateResultInner.class, context);
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtResourceGroup(String resourceGroupName, String deploymentStackName,
            DeploymentStackInner deploymentStack) {
        return this.beginValidateStackAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack)
            .getSyncPoller();
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtResourceGroup(String resourceGroupName, String deploymentStackName,
            DeploymentStackInner deploymentStack, Context context) {
        return this
            .beginValidateStackAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack, context)
            .getSyncPoller();
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackValidateResultInner> validateStackAtResourceGroupAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        return beginValidateStackAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentStackValidateResultInner> validateStackAtResourceGroupAsync(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return beginValidateStackAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtResourceGroup(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        return validateStackAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack).block();
    }

    /**
     * Runs preflight validation on the Resource Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtResourceGroup(String resourceGroupName,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return validateStackAtResourceGroupAsync(resourceGroupName, deploymentStackName, deploymentStack, context)
            .block();
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateStackAtSubscriptionWithResponseAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateStackAtSubscription(this.client.getEndpoint(),
                this.client.getSubscriptionId(), deploymentStackName, this.client.getApiVersion(), deploymentStack,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateStackAtSubscriptionWithResponseAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateStackAtSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(),
            deploymentStackName, this.client.getApiVersion(), deploymentStack, accept, context);
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateStackAtSubscriptionWithResponseAsync(deploymentStackName, deploymentStack);
        return this.client.<DeploymentStackValidateResultInner, DeploymentStackValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentStackValidateResultInner.class,
            DeploymentStackValidateResultInner.class, this.client.getContext());
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtSubscriptionAsync(String deploymentStackName, DeploymentStackInner deploymentStack,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateStackAtSubscriptionWithResponseAsync(deploymentStackName, deploymentStack, context);
        return this.client.<DeploymentStackValidateResultInner, DeploymentStackValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentStackValidateResultInner.class,
            DeploymentStackValidateResultInner.class, context);
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack) {
        return this.beginValidateStackAtSubscriptionAsync(deploymentStackName, deploymentStack).getSyncPoller();
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtSubscription(String deploymentStackName, DeploymentStackInner deploymentStack,
            Context context) {
        return this.beginValidateStackAtSubscriptionAsync(deploymentStackName, deploymentStack, context)
            .getSyncPoller();
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackValidateResultInner> validateStackAtSubscriptionAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack) {
        return beginValidateStackAtSubscriptionAsync(deploymentStackName, deploymentStack).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentStackValidateResultInner> validateStackAtSubscriptionAsync(String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context) {
        return beginValidateStackAtSubscriptionAsync(deploymentStackName, deploymentStack, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtSubscription(String deploymentStackName,
        DeploymentStackInner deploymentStack) {
        return validateStackAtSubscriptionAsync(deploymentStackName, deploymentStack).block();
    }

    /**
     * Runs preflight validation on the Subscription scoped Deployment stack template to verify its acceptance to Azure
     * Resource Manager.
     * 
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtSubscription(String deploymentStackName,
        DeploymentStackInner deploymentStack, Context context) {
        return validateStackAtSubscriptionAsync(deploymentStackName, deploymentStack, context).block();
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateStackAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateStackAtManagementGroup(this.client.getEndpoint(), managementGroupId,
                deploymentStackName, this.client.getApiVersion(), deploymentStack, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateStackAtManagementGroupWithResponseAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (deploymentStackName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStackName is required and cannot be null."));
        }
        if (deploymentStack == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter deploymentStack is required and cannot be null."));
        } else {
            deploymentStack.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateStackAtManagementGroup(this.client.getEndpoint(), managementGroupId, deploymentStackName,
            this.client.getApiVersion(), deploymentStack, accept, context);
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtManagementGroupAsync(String managementGroupId, String deploymentStackName,
            DeploymentStackInner deploymentStack) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = validateStackAtManagementGroupWithResponseAsync(managementGroupId, deploymentStackName, deploymentStack);
        return this.client.<DeploymentStackValidateResultInner, DeploymentStackValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentStackValidateResultInner.class,
            DeploymentStackValidateResultInner.class, this.client.getContext());
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtManagementGroupAsync(String managementGroupId, String deploymentStackName,
            DeploymentStackInner deploymentStack, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = validateStackAtManagementGroupWithResponseAsync(managementGroupId,
            deploymentStackName, deploymentStack, context);
        return this.client.<DeploymentStackValidateResultInner, DeploymentStackValidateResultInner>getLroResult(mono,
            this.client.getHttpPipeline(), DeploymentStackValidateResultInner.class,
            DeploymentStackValidateResultInner.class, context);
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtManagementGroup(String managementGroupId, String deploymentStackName,
            DeploymentStackInner deploymentStack) {
        return this.beginValidateStackAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack)
            .getSyncPoller();
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DeploymentStackValidateResultInner>, DeploymentStackValidateResultInner>
        beginValidateStackAtManagementGroup(String managementGroupId, String deploymentStackName,
            DeploymentStackInner deploymentStack, Context context) {
        return this
            .beginValidateStackAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack, context)
            .getSyncPoller();
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeploymentStackValidateResultInner> validateStackAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        return beginValidateStackAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DeploymentStackValidateResultInner> validateStackAtManagementGroupAsync(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return beginValidateStackAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtManagementGroup(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack) {
        return validateStackAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack).block();
    }

    /**
     * Runs preflight validation on the Management Group scoped Deployment stack template to verify its acceptance to
     * Azure Resource Manager.
     * 
     * @param managementGroupId Management Group id.
     * @param deploymentStackName Name of the deployment stack.
     * @param deploymentStack Deployment stack to validate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Deployment stack validation result.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeploymentStackValidateResultInner validateStackAtManagementGroup(String managementGroupId,
        String deploymentStackName, DeploymentStackInner deploymentStack, Context context) {
        return validateStackAtManagementGroupAsync(managementGroupId, deploymentStackName, deploymentStack, context)
            .block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listAtResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeploymentStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtResourceGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAtResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtSubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listAtSubscriptionNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeploymentStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtSubscriptionNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAtSubscriptionNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listAtManagementGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<DeploymentStackInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of Deployment stacks along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentStackInner>> listAtManagementGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAtManagementGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
