// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The AliasPathMetadata model.
 */
@Immutable
public final class AliasPathMetadata implements JsonSerializable<AliasPathMetadata> {
    /*
     * The type of the token that the alias path is referring to.
     */
    private AliasPathTokenType type;

    /*
     * The attributes of the token that the alias path is referring to.
     */
    private AliasPathAttributes attributes;

    /**
     * Creates an instance of AliasPathMetadata class.
     */
    public AliasPathMetadata() {
    }

    /**
     * Get the type property: The type of the token that the alias path is referring to.
     * 
     * @return the type value.
     */
    public AliasPathTokenType type() {
        return this.type;
    }

    /**
     * Get the attributes property: The attributes of the token that the alias path is referring to.
     * 
     * @return the attributes value.
     */
    public AliasPathAttributes attributes() {
        return this.attributes;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AliasPathMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AliasPathMetadata if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AliasPathMetadata.
     */
    public static AliasPathMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AliasPathMetadata deserializedAliasPathMetadata = new AliasPathMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedAliasPathMetadata.type = AliasPathTokenType.fromString(reader.getString());
                } else if ("attributes".equals(fieldName)) {
                    deserializedAliasPathMetadata.attributes = AliasPathAttributes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAliasPathMetadata;
        });
    }
}
