// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The DeploymentExtensionConfigItem model.
 */
@Fluent
public final class DeploymentExtensionConfigItem implements JsonSerializable<DeploymentExtensionConfigItem> {
    /*
     * The value type of the extension config property.
     */
    private ExtensionConfigPropertyType type;

    /*
     * The value of the extension config property.
     */
    private Object value;

    /*
     * The Azure Key Vault reference used to retrieve the secret value of the extension config property.
     */
    private KeyVaultParameterReference keyVaultReference;

    /**
     * Creates an instance of DeploymentExtensionConfigItem class.
     */
    public DeploymentExtensionConfigItem() {
    }

    /**
     * Get the type property: The value type of the extension config property.
     * 
     * @return the type value.
     */
    public ExtensionConfigPropertyType type() {
        return this.type;
    }

    /**
     * Get the value property: The value of the extension config property.
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the extension config property.
     * 
     * @param value the value value to set.
     * @return the DeploymentExtensionConfigItem object itself.
     */
    public DeploymentExtensionConfigItem withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Get the keyVaultReference property: The Azure Key Vault reference used to retrieve the secret value of the
     * extension config property.
     * 
     * @return the keyVaultReference value.
     */
    public KeyVaultParameterReference keyVaultReference() {
        return this.keyVaultReference;
    }

    /**
     * Set the keyVaultReference property: The Azure Key Vault reference used to retrieve the secret value of the
     * extension config property.
     * 
     * @param keyVaultReference the keyVaultReference value to set.
     * @return the DeploymentExtensionConfigItem object itself.
     */
    public DeploymentExtensionConfigItem withKeyVaultReference(KeyVaultParameterReference keyVaultReference) {
        this.keyVaultReference = keyVaultReference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVaultReference() != null) {
            keyVaultReference().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.value != null) {
            jsonWriter.writeUntypedField("value", this.value);
        }
        jsonWriter.writeJsonField("keyVaultReference", this.keyVaultReference);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentExtensionConfigItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentExtensionConfigItem if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentExtensionConfigItem.
     */
    public static DeploymentExtensionConfigItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentExtensionConfigItem deserializedDeploymentExtensionConfigItem
                = new DeploymentExtensionConfigItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedDeploymentExtensionConfigItem.type
                        = ExtensionConfigPropertyType.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedDeploymentExtensionConfigItem.value = reader.readUntyped();
                } else if ("keyVaultReference".equals(fieldName)) {
                    deserializedDeploymentExtensionConfigItem.keyVaultReference
                        = KeyVaultParameterReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentExtensionConfigItem;
        });
    }
}
