// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The DeploymentExtensionDefinition model.
 */
@Immutable
public final class DeploymentExtensionDefinition implements JsonSerializable<DeploymentExtensionDefinition> {
    /*
     * The alias of the extension as defined in the deployment template.
     */
    private String alias;

    /*
     * The extension name.
     */
    private String name;

    /*
     * The extension version.
     */
    private String version;

    /*
     * The extension configuration ID. It uniquely identifies a deployment control plane within an extension.
     */
    private String configId;

    /*
     * The extension configuration.
     */
    private Map<String, DeploymentExtensionConfigItem> config;

    /**
     * Creates an instance of DeploymentExtensionDefinition class.
     */
    public DeploymentExtensionDefinition() {
    }

    /**
     * Get the alias property: The alias of the extension as defined in the deployment template.
     * 
     * @return the alias value.
     */
    public String alias() {
        return this.alias;
    }

    /**
     * Get the name property: The extension name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the version property: The extension version.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the configId property: The extension configuration ID. It uniquely identifies a deployment control plane
     * within an extension.
     * 
     * @return the configId value.
     */
    public String configId() {
        return this.configId;
    }

    /**
     * Get the config property: The extension configuration.
     * 
     * @return the config value.
     */
    public Map<String, DeploymentExtensionConfigItem> config() {
        return this.config;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (config() != null) {
            config().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentExtensionDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentExtensionDefinition if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentExtensionDefinition.
     */
    public static DeploymentExtensionDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentExtensionDefinition deserializedDeploymentExtensionDefinition
                = new DeploymentExtensionDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("alias".equals(fieldName)) {
                    deserializedDeploymentExtensionDefinition.alias = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDeploymentExtensionDefinition.name = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedDeploymentExtensionDefinition.version = reader.getString();
                } else if ("configId".equals(fieldName)) {
                    deserializedDeploymentExtensionDefinition.configId = reader.getString();
                } else if ("config".equals(fieldName)) {
                    Map<String, DeploymentExtensionConfigItem> config
                        = reader.readMap(reader1 -> DeploymentExtensionConfigItem.fromJson(reader1));
                    deserializedDeploymentExtensionDefinition.config = config;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentExtensionDefinition;
        });
    }
}
