// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deployment external input for parameterization.
 */
@Fluent
public final class DeploymentExternalInput implements JsonSerializable<DeploymentExternalInput> {
    /*
     * External input value.
     */
    private Object value;

    /**
     * Creates an instance of DeploymentExternalInput class.
     */
    public DeploymentExternalInput() {
    }

    /**
     * Get the value property: External input value.
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: External input value.
     * 
     * @param value the value value to set.
     * @return the DeploymentExternalInput object itself.
     */
    public DeploymentExternalInput withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model DeploymentExternalInput"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeploymentExternalInput.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentExternalInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentExternalInput if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeploymentExternalInput.
     */
    public static DeploymentExternalInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentExternalInput deserializedDeploymentExternalInput = new DeploymentExternalInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedDeploymentExternalInput.value = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentExternalInput;
        });
    }
}
