// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Deployment operation properties.
 */
@Immutable
public final class DeploymentOperationProperties implements JsonSerializable<DeploymentOperationProperties> {
    /*
     * The name of the current provisioning operation.
     */
    private ProvisioningOperation provisioningOperation;

    /*
     * The state of the provisioning.
     */
    private String provisioningState;

    /*
     * The date and time of the operation.
     */
    private OffsetDateTime timestamp;

    /*
     * The duration of the operation.
     */
    private String duration;

    /*
     * Deployment operation service request id.
     */
    private String serviceRequestId;

    /*
     * Operation status code from the resource provider. This property may not be set if a response has not yet been
     * received.
     */
    private String statusCode;

    /*
     * Operation status message from the resource provider. This property is optional. It will only be provided if an
     * error was received from the resource provider.
     */
    private StatusMessage statusMessage;

    /*
     * The target resource.
     */
    private TargetResource targetResource;

    /*
     * The HTTP request message.
     */
    private HttpMessage request;

    /*
     * The HTTP response message.
     */
    private HttpMessage response;

    /**
     * Creates an instance of DeploymentOperationProperties class.
     */
    public DeploymentOperationProperties() {
    }

    /**
     * Get the provisioningOperation property: The name of the current provisioning operation.
     * 
     * @return the provisioningOperation value.
     */
    public ProvisioningOperation provisioningOperation() {
        return this.provisioningOperation;
    }

    /**
     * Get the provisioningState property: The state of the provisioning.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the timestamp property: The date and time of the operation.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Get the duration property: The duration of the operation.
     * 
     * @return the duration value.
     */
    public String duration() {
        return this.duration;
    }

    /**
     * Get the serviceRequestId property: Deployment operation service request id.
     * 
     * @return the serviceRequestId value.
     */
    public String serviceRequestId() {
        return this.serviceRequestId;
    }

    /**
     * Get the statusCode property: Operation status code from the resource provider. This property may not be set if a
     * response has not yet been received.
     * 
     * @return the statusCode value.
     */
    public String statusCode() {
        return this.statusCode;
    }

    /**
     * Get the statusMessage property: Operation status message from the resource provider. This property is optional.
     * It will only be provided if an error was received from the resource provider.
     * 
     * @return the statusMessage value.
     */
    public StatusMessage statusMessage() {
        return this.statusMessage;
    }

    /**
     * Get the targetResource property: The target resource.
     * 
     * @return the targetResource value.
     */
    public TargetResource targetResource() {
        return this.targetResource;
    }

    /**
     * Get the request property: The HTTP request message.
     * 
     * @return the request value.
     */
    public HttpMessage request() {
        return this.request;
    }

    /**
     * Get the response property: The HTTP response message.
     * 
     * @return the response value.
     */
    public HttpMessage response() {
        return this.response;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (statusMessage() != null) {
            statusMessage().validate();
        }
        if (targetResource() != null) {
            targetResource().validate();
        }
        if (request() != null) {
            request().validate();
        }
        if (response() != null) {
            response().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentOperationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentOperationProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentOperationProperties.
     */
    public static DeploymentOperationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentOperationProperties deserializedDeploymentOperationProperties
                = new DeploymentOperationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningOperation".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.provisioningOperation
                        = ProvisioningOperation.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.provisioningState = reader.getString();
                } else if ("timestamp".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("duration".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.duration = reader.getString();
                } else if ("serviceRequestId".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.serviceRequestId = reader.getString();
                } else if ("statusCode".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.statusCode = reader.getString();
                } else if ("statusMessage".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.statusMessage = StatusMessage.fromJson(reader);
                } else if ("targetResource".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.targetResource = TargetResource.fromJson(reader);
                } else if ("request".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.request = HttpMessage.fromJson(reader);
                } else if ("response".equals(fieldName)) {
                    deserializedDeploymentOperationProperties.response = HttpMessage.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentOperationProperties;
        });
    }
}
