// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

/**
 * The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
 */
public enum OnErrorDeploymentType {
    /**
     * Enum value LastSuccessful.
     */
    LAST_SUCCESSFUL("LastSuccessful"),

    /**
     * Enum value SpecificDeployment.
     */
    SPECIFIC_DEPLOYMENT("SpecificDeployment");

    /**
     * The actual serialized value for a OnErrorDeploymentType instance.
     */
    private final String value;

    OnErrorDeploymentType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a OnErrorDeploymentType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed OnErrorDeploymentType object, or null if unable to parse.
     */
    public static OnErrorDeploymentType fromString(String value) {
        if (value == null) {
            return null;
        }
        OnErrorDeploymentType[] items = OnErrorDeploymentType.values();
        for (OnErrorDeploymentType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
