// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Target resource.
 */
@Fluent
public final class TargetResource implements JsonSerializable<TargetResource> {
    /*
     * The Azure resource ID of the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String resourceName;

    /*
     * The type of the resource.
     */
    private String resourceType;

    /*
     * The extension the resource was deployed with.
     */
    private DeploymentExtensionDefinition extension;

    /*
     * The extensible resource identifiers.
     */
    private Object identifiers;

    /*
     * The API version the resource was deployed with.
     */
    private String apiVersion;

    /*
     * The symbolic name of the resource as defined in the deployment template.
     */
    private String symbolicName;

    /**
     * Creates an instance of TargetResource class.
     */
    public TargetResource() {
    }

    /**
     * Get the id property: The Azure resource ID of the resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The Azure resource ID of the resource.
     * 
     * @param id the id value to set.
     * @return the TargetResource object itself.
     */
    public TargetResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the resourceName property: The name of the resource.
     * 
     * @return the resourceName value.
     */
    public String resourceName() {
        return this.resourceName;
    }

    /**
     * Set the resourceName property: The name of the resource.
     * 
     * @param resourceName the resourceName value to set.
     * @return the TargetResource object itself.
     */
    public TargetResource withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    /**
     * Get the resourceType property: The type of the resource.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Set the resourceType property: The type of the resource.
     * 
     * @param resourceType the resourceType value to set.
     * @return the TargetResource object itself.
     */
    public TargetResource withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    /**
     * Get the extension property: The extension the resource was deployed with.
     * 
     * @return the extension value.
     */
    public DeploymentExtensionDefinition extension() {
        return this.extension;
    }

    /**
     * Set the extension property: The extension the resource was deployed with.
     * 
     * @param extension the extension value to set.
     * @return the TargetResource object itself.
     */
    public TargetResource withExtension(DeploymentExtensionDefinition extension) {
        this.extension = extension;
        return this;
    }

    /**
     * Get the identifiers property: The extensible resource identifiers.
     * 
     * @return the identifiers value.
     */
    public Object identifiers() {
        return this.identifiers;
    }

    /**
     * Set the identifiers property: The extensible resource identifiers.
     * 
     * @param identifiers the identifiers value to set.
     * @return the TargetResource object itself.
     */
    public TargetResource withIdentifiers(Object identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    /**
     * Get the apiVersion property: The API version the resource was deployed with.
     * 
     * @return the apiVersion value.
     */
    public String apiVersion() {
        return this.apiVersion;
    }

    /**
     * Set the apiVersion property: The API version the resource was deployed with.
     * 
     * @param apiVersion the apiVersion value to set.
     * @return the TargetResource object itself.
     */
    public TargetResource withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    /**
     * Get the symbolicName property: The symbolic name of the resource as defined in the deployment template.
     * 
     * @return the symbolicName value.
     */
    public String symbolicName() {
        return this.symbolicName;
    }

    /**
     * Set the symbolicName property: The symbolic name of the resource as defined in the deployment template.
     * 
     * @param symbolicName the symbolicName value to set.
     * @return the TargetResource object itself.
     */
    public TargetResource withSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extension() != null) {
            extension().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeJsonField("extension", this.extension);
        if (this.identifiers != null) {
            jsonWriter.writeUntypedField("identifiers", this.identifiers);
        }
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeStringField("symbolicName", this.symbolicName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TargetResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TargetResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TargetResource.
     */
    public static TargetResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TargetResource deserializedTargetResource = new TargetResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTargetResource.id = reader.getString();
                } else if ("resourceName".equals(fieldName)) {
                    deserializedTargetResource.resourceName = reader.getString();
                } else if ("resourceType".equals(fieldName)) {
                    deserializedTargetResource.resourceType = reader.getString();
                } else if ("extension".equals(fieldName)) {
                    deserializedTargetResource.extension = DeploymentExtensionDefinition.fromJson(reader);
                } else if ("identifiers".equals(fieldName)) {
                    deserializedTargetResource.identifiers = reader.readUntyped();
                } else if ("apiVersion".equals(fieldName)) {
                    deserializedTargetResource.apiVersion = reader.getString();
                } else if ("symbolicName".equals(fieldName)) {
                    deserializedTargetResource.symbolicName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTargetResource;
        });
    }
}
