/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class AuthorizationProfile
implements JsonSerializable<AuthorizationProfile> {
    private OffsetDateTime requestedTime;
    private String requester;
    private String requesterObjectId;
    private OffsetDateTime approvedTime;
    private String approver;

    public OffsetDateTime requestedTime() {
        return this.requestedTime;
    }

    public String requester() {
        return this.requester;
    }

    public String requesterObjectId() {
        return this.requesterObjectId;
    }

    public OffsetDateTime approvedTime() {
        return this.approvedTime;
    }

    public String approver() {
        return this.approver;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static AuthorizationProfile fromJson(JsonReader jsonReader) throws IOException {
        return (AuthorizationProfile)jsonReader.readObject(reader -> {
            AuthorizationProfile deserializedAuthorizationProfile = new AuthorizationProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("requestedTime".equals(fieldName)) {
                    deserializedAuthorizationProfile.requestedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("requester".equals(fieldName)) {
                    deserializedAuthorizationProfile.requester = reader.getString();
                    continue;
                }
                if ("requesterObjectId".equals(fieldName)) {
                    deserializedAuthorizationProfile.requesterObjectId = reader.getString();
                    continue;
                }
                if ("approvedTime".equals(fieldName)) {
                    deserializedAuthorizationProfile.approvedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("approver".equals(fieldName)) {
                    deserializedAuthorizationProfile.approver = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthorizationProfile;
        });
    }
}

