/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.OverrideKind;
import com.azure.resourcemanager.resources.models.Selector;
import java.io.IOException;
import java.util.List;

public final class OverrideModel
implements JsonSerializable<OverrideModel> {
    private OverrideKind kind;
    private String value;
    private List<Selector> selectors;

    public OverrideKind kind() {
        return this.kind;
    }

    public OverrideModel withKind(OverrideKind kind) {
        this.kind = kind;
        return this;
    }

    public String value() {
        return this.value;
    }

    public OverrideModel withValue(String value) {
        this.value = value;
        return this;
    }

    public List<Selector> selectors() {
        return this.selectors;
    }

    public OverrideModel withSelectors(List<Selector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public void validate() {
        if (this.selectors() != null) {
            this.selectors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeArrayField("selectors", this.selectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OverrideModel fromJson(JsonReader jsonReader) throws IOException {
        return (OverrideModel)jsonReader.readObject(reader -> {
            OverrideModel deserializedOverrideModel = new OverrideModel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedOverrideModel.kind = OverrideKind.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedOverrideModel.value = reader.getString();
                    continue;
                }
                if ("selectors".equals(fieldName)) {
                    List selectors;
                    deserializedOverrideModel.selectors = selectors = reader.readArray(reader1 -> Selector.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOverrideModel;
        });
    }
}

