// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluent.models.DataBoundaryDefinitionInner;
import com.azure.resourcemanager.resources.models.DefaultName;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DataBoundariesClient.
 */
public interface DataBoundariesClient {
    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DataBoundaryDefinitionInner>> putWithResponseAsync(DefaultName defaultParameter,
        DataBoundaryDefinitionInner dataBoundaryDefinition);

    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DataBoundaryDefinitionInner> putAsync(DefaultName defaultParameter,
        DataBoundaryDefinitionInner dataBoundaryDefinition);

    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DataBoundaryDefinitionInner> putWithResponse(DefaultName defaultParameter,
        DataBoundaryDefinitionInner dataBoundaryDefinition, Context context);

    /**
     * Opt-in tenant to data boundary.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param dataBoundaryDefinition The data boundary to opt the tenant to.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data boundary definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DataBoundaryDefinitionInner put(DefaultName defaultParameter, DataBoundaryDefinitionInner dataBoundaryDefinition);

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DataBoundaryDefinitionInner>> getTenantWithResponseAsync(DefaultName defaultParameter);

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DataBoundaryDefinitionInner> getTenantAsync(DefaultName defaultParameter);

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DataBoundaryDefinitionInner> getTenantWithResponse(DefaultName defaultParameter, Context context);

    /**
     * Get data boundary of tenant.
     * 
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary of tenant.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DataBoundaryDefinitionInner getTenant(DefaultName defaultParameter);

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DataBoundaryDefinitionInner>> getScopeWithResponseAsync(String scope, DefaultName defaultParameter);

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DataBoundaryDefinitionInner> getScopeAsync(String scope, DefaultName defaultParameter);

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DataBoundaryDefinitionInner> getScopeWithResponse(String scope, DefaultName defaultParameter,
        Context context);

    /**
     * Get data boundary at specified scope.
     * 
     * @param scope The scope at which the operation is performed.
     * @param defaultParameter Default string modeled as parameter for auto generation to work correctly.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data boundary at specified scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DataBoundaryDefinitionInner getScope(String scope, DefaultName defaultParameter);
}
