// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AvailabilityZonePeers;
import java.io.IOException;
import java.util.List;

/**
 * Result of the Check zone peers operation.
 */
@Fluent
public final class CheckZonePeersResultInner implements JsonSerializable<CheckZonePeersResultInner> {
    /*
     * The subscription ID.
     */
    private String subscriptionId;

    /*
     * the location of the subscription.
     */
    private String location;

    /*
     * The Availability Zones shared by the subscriptions.
     */
    private List<AvailabilityZonePeers> availabilityZonePeers;

    /**
     * Creates an instance of CheckZonePeersResultInner class.
     */
    public CheckZonePeersResultInner() {
    }

    /**
     * Get the subscriptionId property: The subscription ID.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Get the location property: the location of the subscription.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: the location of the subscription.
     * 
     * @param location the location value to set.
     * @return the CheckZonePeersResultInner object itself.
     */
    public CheckZonePeersResultInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the availabilityZonePeers property: The Availability Zones shared by the subscriptions.
     * 
     * @return the availabilityZonePeers value.
     */
    public List<AvailabilityZonePeers> availabilityZonePeers() {
        return this.availabilityZonePeers;
    }

    /**
     * Set the availabilityZonePeers property: The Availability Zones shared by the subscriptions.
     * 
     * @param availabilityZonePeers the availabilityZonePeers value to set.
     * @return the CheckZonePeersResultInner object itself.
     */
    public CheckZonePeersResultInner withAvailabilityZonePeers(List<AvailabilityZonePeers> availabilityZonePeers) {
        this.availabilityZonePeers = availabilityZonePeers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (availabilityZonePeers() != null) {
            availabilityZonePeers().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("availabilityZonePeers", this.availabilityZonePeers,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckZonePeersResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckZonePeersResultInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CheckZonePeersResultInner.
     */
    public static CheckZonePeersResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckZonePeersResultInner deserializedCheckZonePeersResultInner = new CheckZonePeersResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subscriptionId".equals(fieldName)) {
                    deserializedCheckZonePeersResultInner.subscriptionId = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedCheckZonePeersResultInner.location = reader.getString();
                } else if ("availabilityZonePeers".equals(fieldName)) {
                    List<AvailabilityZonePeers> availabilityZonePeers
                        = reader.readArray(reader1 -> AvailabilityZonePeers.fromJson(reader1));
                    deserializedCheckZonePeersResultInner.availabilityZonePeers = availabilityZonePeers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckZonePeersResultInner;
        });
    }
}
