/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.OverrideModel;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.util.List;

public final class PolicyAssignmentUpdateProperties
implements JsonSerializable<PolicyAssignmentUpdateProperties> {
    private List<ResourceSelector> resourceSelectors;
    private List<OverrideModel> overrides;

    public List<ResourceSelector> resourceSelectors() {
        return this.resourceSelectors;
    }

    public PolicyAssignmentUpdateProperties withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        this.resourceSelectors = resourceSelectors;
        return this;
    }

    public List<OverrideModel> overrides() {
        return this.overrides;
    }

    public PolicyAssignmentUpdateProperties withOverrides(List<OverrideModel> overrides) {
        this.overrides = overrides;
        return this;
    }

    public void validate() {
        if (this.resourceSelectors() != null) {
            this.resourceSelectors().forEach(e -> e.validate());
        }
        if (this.overrides() != null) {
            this.overrides().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("resourceSelectors", this.resourceSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("overrides", this.overrides, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicyAssignmentUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyAssignmentUpdateProperties)jsonReader.readObject(reader -> {
            PolicyAssignmentUpdateProperties deserializedPolicyAssignmentUpdateProperties = new PolicyAssignmentUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceSelectors".equals(fieldName)) {
                    List resourceSelectors;
                    deserializedPolicyAssignmentUpdateProperties.resourceSelectors = resourceSelectors = reader.readArray(reader1 -> ResourceSelector.fromJson(reader1));
                    continue;
                }
                if ("overrides".equals(fieldName)) {
                    List overrides;
                    deserializedPolicyAssignmentUpdateProperties.overrides = overrides = reader.readArray(reader1 -> OverrideModel.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyAssignmentUpdateProperties;
        });
    }
}

