/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ActionOnUnmanage;
import com.azure.resourcemanager.resources.models.DenySettings;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.DeploymentStacksTemplateLink;
import com.azure.resourcemanager.resources.models.ResourceReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DeploymentStackValidateProperties
implements JsonSerializable<DeploymentStackValidateProperties> {
    private ActionOnUnmanage actionOnUnmanage;
    private String correlationId;
    private DenySettings denySettings;
    private String deploymentScope;
    private String description;
    private Map<String, DeploymentParameter> parameters;
    private DeploymentStacksTemplateLink templateLink;
    private List<ResourceReference> validatedResources;

    public ActionOnUnmanage actionOnUnmanage() {
        return this.actionOnUnmanage;
    }

    public DeploymentStackValidateProperties withActionOnUnmanage(ActionOnUnmanage actionOnUnmanage) {
        this.actionOnUnmanage = actionOnUnmanage;
        return this;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public DeploymentStackValidateProperties withCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public DenySettings denySettings() {
        return this.denySettings;
    }

    public DeploymentStackValidateProperties withDenySettings(DenySettings denySettings) {
        this.denySettings = denySettings;
        return this;
    }

    public String deploymentScope() {
        return this.deploymentScope;
    }

    public DeploymentStackValidateProperties withDeploymentScope(String deploymentScope) {
        this.deploymentScope = deploymentScope;
        return this;
    }

    public String description() {
        return this.description;
    }

    public DeploymentStackValidateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, DeploymentParameter> parameters() {
        return this.parameters;
    }

    public DeploymentStackValidateProperties withParameters(Map<String, DeploymentParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public DeploymentStacksTemplateLink templateLink() {
        return this.templateLink;
    }

    public DeploymentStackValidateProperties withTemplateLink(DeploymentStacksTemplateLink templateLink) {
        this.templateLink = templateLink;
        return this;
    }

    public List<ResourceReference> validatedResources() {
        return this.validatedResources;
    }

    public DeploymentStackValidateProperties withValidatedResources(List<ResourceReference> validatedResources) {
        this.validatedResources = validatedResources;
        return this;
    }

    public void validate() {
        if (this.actionOnUnmanage() != null) {
            this.actionOnUnmanage().validate();
        }
        if (this.denySettings() != null) {
            this.denySettings().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.templateLink() != null) {
            this.templateLink().validate();
        }
        if (this.validatedResources() != null) {
            this.validatedResources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("actionOnUnmanage", (JsonSerializable)this.actionOnUnmanage);
        jsonWriter.writeStringField("correlationId", this.correlationId);
        jsonWriter.writeJsonField("denySettings", (JsonSerializable)this.denySettings);
        jsonWriter.writeStringField("deploymentScope", this.deploymentScope);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("templateLink", (JsonSerializable)this.templateLink);
        jsonWriter.writeArrayField("validatedResources", this.validatedResources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DeploymentStackValidateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentStackValidateProperties)jsonReader.readObject(reader -> {
            DeploymentStackValidateProperties deserializedDeploymentStackValidateProperties = new DeploymentStackValidateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actionOnUnmanage".equals(fieldName)) {
                    deserializedDeploymentStackValidateProperties.actionOnUnmanage = ActionOnUnmanage.fromJson(reader);
                    continue;
                }
                if ("correlationId".equals(fieldName)) {
                    deserializedDeploymentStackValidateProperties.correlationId = reader.getString();
                    continue;
                }
                if ("denySettings".equals(fieldName)) {
                    deserializedDeploymentStackValidateProperties.denySettings = DenySettings.fromJson(reader);
                    continue;
                }
                if ("deploymentScope".equals(fieldName)) {
                    deserializedDeploymentStackValidateProperties.deploymentScope = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDeploymentStackValidateProperties.description = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDeploymentStackValidateProperties.parameters = parameters = reader.readMap(reader1 -> DeploymentParameter.fromJson(reader1));
                    continue;
                }
                if ("templateLink".equals(fieldName)) {
                    deserializedDeploymentStackValidateProperties.templateLink = DeploymentStacksTemplateLink.fromJson(reader);
                    continue;
                }
                if ("validatedResources".equals(fieldName)) {
                    List validatedResources;
                    deserializedDeploymentStackValidateProperties.validatedResources = validatedResources = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentStackValidateProperties;
        });
    }
}

