/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentExtensionDefinition;
import java.io.IOException;

public final class TargetResource
implements JsonSerializable<TargetResource> {
    private String id;
    private String resourceName;
    private String resourceType;
    private DeploymentExtensionDefinition extension;
    private Object identifiers;
    private String apiVersion;
    private String symbolicName;

    public String id() {
        return this.id;
    }

    public TargetResource withId(String id) {
        this.id = id;
        return this;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public TargetResource withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public TargetResource withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public DeploymentExtensionDefinition extension() {
        return this.extension;
    }

    public TargetResource withExtension(DeploymentExtensionDefinition extension) {
        this.extension = extension;
        return this;
    }

    public Object identifiers() {
        return this.identifiers;
    }

    public TargetResource withIdentifiers(Object identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public TargetResource withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String symbolicName() {
        return this.symbolicName;
    }

    public TargetResource withSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
        return this;
    }

    public void validate() {
        if (this.extension() != null) {
            this.extension().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeJsonField("extension", (JsonSerializable)this.extension);
        if (this.identifiers != null) {
            jsonWriter.writeUntypedField("identifiers", this.identifiers);
        }
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeStringField("symbolicName", this.symbolicName);
        return jsonWriter.writeEndObject();
    }

    public static TargetResource fromJson(JsonReader jsonReader) throws IOException {
        return (TargetResource)jsonReader.readObject(reader -> {
            TargetResource deserializedTargetResource = new TargetResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTargetResource.id = reader.getString();
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedTargetResource.resourceName = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedTargetResource.resourceType = reader.getString();
                    continue;
                }
                if ("extension".equals(fieldName)) {
                    deserializedTargetResource.extension = DeploymentExtensionDefinition.fromJson(reader);
                    continue;
                }
                if ("identifiers".equals(fieldName)) {
                    deserializedTargetResource.identifiers = reader.readUntyped();
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedTargetResource.apiVersion = reader.getString();
                    continue;
                }
                if ("symbolicName".equals(fieldName)) {
                    deserializedTargetResource.symbolicName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetResource;
        });
    }
}

