// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluent.models.PolicyDefinitionVersionInner;
import com.azure.resourcemanager.resources.fluent.models.PolicyDefinitionVersionListResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PolicyDefinitionVersionsClient.
 */
public interface PolicyDefinitionVersionsClient extends InnerSupportsDelete<Void> {
    /**
     * Lists all built-in policy definition versions.
     * 
     * This operation lists all the built-in policy definition versions for all built-in policy definitions.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicyDefinitionVersionListResultInner>> listAllBuiltinsWithResponseAsync();

    /**
     * Lists all built-in policy definition versions.
     * 
     * This operation lists all the built-in policy definition versions for all built-in policy definitions.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicyDefinitionVersionListResultInner> listAllBuiltinsAsync();

    /**
     * Lists all built-in policy definition versions.
     * 
     * This operation lists all the built-in policy definition versions for all built-in policy definitions.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicyDefinitionVersionListResultInner> listAllBuiltinsWithResponse(Context context);

    /**
     * Lists all built-in policy definition versions.
     * 
     * This operation lists all the built-in policy definition versions for all built-in policy definitions.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyDefinitionVersionListResultInner listAllBuiltins();

    /**
     * Lists all policy definition versions at management group scope.
     * 
     * This operation lists all the policy definition versions for all policy definitions at the management group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicyDefinitionVersionListResultInner>>
        listAllAtManagementGroupWithResponseAsync(String managementGroupName);

    /**
     * Lists all policy definition versions at management group scope.
     * 
     * This operation lists all the policy definition versions for all policy definitions at the management group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicyDefinitionVersionListResultInner> listAllAtManagementGroupAsync(String managementGroupName);

    /**
     * Lists all policy definition versions at management group scope.
     * 
     * This operation lists all the policy definition versions for all policy definitions at the management group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicyDefinitionVersionListResultInner> listAllAtManagementGroupWithResponse(String managementGroupName,
        Context context);

    /**
     * Lists all policy definition versions at management group scope.
     * 
     * This operation lists all the policy definition versions for all policy definitions at the management group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyDefinitionVersionListResultInner listAllAtManagementGroup(String managementGroupName);

    /**
     * Lists all policy definition versions within a subscription.
     * 
     * This operation lists all the policy definition versions for all policy definitions within a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicyDefinitionVersionListResultInner>> listAllWithResponseAsync();

    /**
     * Lists all policy definition versions within a subscription.
     * 
     * This operation lists all the policy definition versions for all policy definitions within a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicyDefinitionVersionListResultInner> listAllAsync();

    /**
     * Lists all policy definition versions within a subscription.
     * 
     * This operation lists all the policy definition versions for all policy definitions within a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicyDefinitionVersionListResultInner> listAllWithResponse(Context context);

    /**
     * Lists all policy definition versions within a subscription.
     * 
     * This operation lists all the policy definition versions for all policy definitions within a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyDefinitionVersionListResultInner listAll();

    /**
     * Creates or updates a policy definition in a subscription.
     * 
     * This operation creates or updates a policy definition in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param parameters The policy definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicyDefinitionVersionInner>> createOrUpdateWithResponseAsync(String policyDefinitionName,
        String policyDefinitionVersion, PolicyDefinitionVersionInner parameters);

    /**
     * Creates or updates a policy definition in a subscription.
     * 
     * This operation creates or updates a policy definition in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param parameters The policy definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicyDefinitionVersionInner> createOrUpdateAsync(String policyDefinitionName, String policyDefinitionVersion,
        PolicyDefinitionVersionInner parameters);

    /**
     * Creates or updates a policy definition in a subscription.
     * 
     * This operation creates or updates a policy definition in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param parameters The policy definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicyDefinitionVersionInner> createOrUpdateWithResponse(String policyDefinitionName,
        String policyDefinitionVersion, PolicyDefinitionVersionInner parameters, Context context);

    /**
     * Creates or updates a policy definition in a subscription.
     * 
     * This operation creates or updates a policy definition in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param parameters The policy definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyDefinitionVersionInner createOrUpdate(String policyDefinitionName, String policyDefinitionVersion,
        PolicyDefinitionVersionInner parameters);

    /**
     * Deletes a policy definition version in a subscription.
     * 
     * This operation deletes the policy definition version in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Deletes a policy definition version in a subscription.
     * 
     * This operation deletes the policy definition version in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Deletes a policy definition version in a subscription.
     * 
     * This operation deletes the policy definition version in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String policyDefinitionName, String policyDefinitionVersion, Context context);

    /**
     * Deletes a policy definition version in a subscription.
     * 
     * This operation deletes the policy definition version in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves a policy definition version in a subscription.
     * 
     * This operation retrieves the policy definition version in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicyDefinitionVersionInner>> getWithResponseAsync(String policyDefinitionName,
        String policyDefinitionVersion);

    /**
     * Retrieves a policy definition version in a subscription.
     * 
     * This operation retrieves the policy definition version in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicyDefinitionVersionInner> getAsync(String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves a policy definition version in a subscription.
     * 
     * This operation retrieves the policy definition version in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicyDefinitionVersionInner> getWithResponse(String policyDefinitionName, String policyDefinitionVersion,
        Context context);

    /**
     * Retrieves a policy definition version in a subscription.
     * 
     * This operation retrieves the policy definition version in the given subscription with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyDefinitionVersionInner get(String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves a built-in policy definition version.
     * 
     * This operation retrieves the built-in policy definition version with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicyDefinitionVersionInner>> getBuiltInWithResponseAsync(String policyDefinitionName,
        String policyDefinitionVersion);

    /**
     * Retrieves a built-in policy definition version.
     * 
     * This operation retrieves the built-in policy definition version with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicyDefinitionVersionInner> getBuiltInAsync(String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves a built-in policy definition version.
     * 
     * This operation retrieves the built-in policy definition version with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicyDefinitionVersionInner> getBuiltInWithResponse(String policyDefinitionName,
        String policyDefinitionVersion, Context context);

    /**
     * Retrieves a built-in policy definition version.
     * 
     * This operation retrieves the built-in policy definition version with the given name.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyDefinitionVersionInner getBuiltIn(String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Creates or updates a policy definition version in a management group.
     * 
     * This operation creates or updates a policy definition version in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param parameters The policy definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicyDefinitionVersionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String managementGroupName, String policyDefinitionName, String policyDefinitionVersion,
        PolicyDefinitionVersionInner parameters);

    /**
     * Creates or updates a policy definition version in a management group.
     * 
     * This operation creates or updates a policy definition version in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param parameters The policy definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicyDefinitionVersionInner> createOrUpdateAtManagementGroupAsync(String managementGroupName,
        String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters);

    /**
     * Creates or updates a policy definition version in a management group.
     * 
     * This operation creates or updates a policy definition version in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param parameters The policy definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicyDefinitionVersionInner> createOrUpdateAtManagementGroupWithResponse(String managementGroupName,
        String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters,
        Context context);

    /**
     * Creates or updates a policy definition version in a management group.
     * 
     * This operation creates or updates a policy definition version in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param parameters The policy definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyDefinitionVersionInner createOrUpdateAtManagementGroup(String managementGroupName,
        String policyDefinitionName, String policyDefinitionVersion, PolicyDefinitionVersionInner parameters);

    /**
     * Deletes a policy definition in a management group.
     * 
     * This operation deletes the policy definition in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String managementGroupName,
        String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Deletes a policy definition in a management group.
     * 
     * This operation deletes the policy definition in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtManagementGroupAsync(String managementGroupName, String policyDefinitionName,
        String policyDefinitionVersion);

    /**
     * Deletes a policy definition in a management group.
     * 
     * This operation deletes the policy definition in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAtManagementGroupWithResponse(String managementGroupName, String policyDefinitionName,
        String policyDefinitionVersion, Context context);

    /**
     * Deletes a policy definition in a management group.
     * 
     * This operation deletes the policy definition in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtManagementGroup(String managementGroupName, String policyDefinitionName,
        String policyDefinitionVersion);

    /**
     * Retrieve a policy definition version in a management group.
     * 
     * This operation retrieves the policy definition version in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicyDefinitionVersionInner>> getAtManagementGroupWithResponseAsync(String managementGroupName,
        String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieve a policy definition version in a management group.
     * 
     * This operation retrieves the policy definition version in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicyDefinitionVersionInner> getAtManagementGroupAsync(String managementGroupName,
        String policyDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieve a policy definition version in a management group.
     * 
     * This operation retrieves the policy definition version in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicyDefinitionVersionInner> getAtManagementGroupWithResponse(String managementGroupName,
        String policyDefinitionName, String policyDefinitionVersion, Context context);

    /**
     * Retrieve a policy definition version in a management group.
     * 
     * This operation retrieves the policy definition version in the given management group with the given name.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param policyDefinitionVersion The policy definition version. The format is x.y.z where x is the major version
     * number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ID of the policy definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicyDefinitionVersionInner getAtManagementGroup(String managementGroupName, String policyDefinitionName,
        String policyDefinitionVersion);

    /**
     * Retrieves policy definition versions for a given policy definition in a subscription
     * 
     * This operation retrieves a list of all the policy definition versions for the given policy definition.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicyDefinitionVersionInner> listAsync(String policyDefinitionName, Integer top);

    /**
     * Retrieves policy definition versions for a given policy definition in a subscription
     * 
     * This operation retrieves a list of all the policy definition versions for the given policy definition.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicyDefinitionVersionInner> listAsync(String policyDefinitionName);

    /**
     * Retrieves policy definition versions for a given policy definition in a subscription
     * 
     * This operation retrieves a list of all the policy definition versions for the given policy definition.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicyDefinitionVersionInner> list(String policyDefinitionName);

    /**
     * Retrieves policy definition versions for a given policy definition in a subscription
     * 
     * This operation retrieves a list of all the policy definition versions for the given policy definition.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicyDefinitionVersionInner> list(String policyDefinitionName, Integer top, Context context);

    /**
     * Retrieve built-in policy definition versions
     * 
     * This operation retrieves a list of all the built-in policy definition versions for the given policy definition.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicyDefinitionVersionInner> listBuiltInAsync(String policyDefinitionName, Integer top);

    /**
     * Retrieve built-in policy definition versions
     * 
     * This operation retrieves a list of all the built-in policy definition versions for the given policy definition.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicyDefinitionVersionInner> listBuiltInAsync(String policyDefinitionName);

    /**
     * Retrieve built-in policy definition versions
     * 
     * This operation retrieves a list of all the built-in policy definition versions for the given policy definition.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicyDefinitionVersionInner> listBuiltIn(String policyDefinitionName);

    /**
     * Retrieve built-in policy definition versions
     * 
     * This operation retrieves a list of all the built-in policy definition versions for the given policy definition.
     * 
     * @param policyDefinitionName The name of the policy definition.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicyDefinitionVersionInner> listBuiltIn(String policyDefinitionName, Integer top, Context context);

    /**
     * Retrieve policy definition versions in a management group policy definition.
     * 
     * This operation retrieves a list of all the policy definition versions for the given policy definition in the
     * given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicyDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName,
        String policyDefinitionName, Integer top);

    /**
     * Retrieve policy definition versions in a management group policy definition.
     * 
     * This operation retrieves a list of all the policy definition versions for the given policy definition in the
     * given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicyDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName,
        String policyDefinitionName);

    /**
     * Retrieve policy definition versions in a management group policy definition.
     * 
     * This operation retrieves a list of all the policy definition versions for the given policy definition in the
     * given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicyDefinitionVersionInner> listByManagementGroup(String managementGroupName,
        String policyDefinitionName);

    /**
     * Retrieve policy definition versions in a management group policy definition.
     * 
     * This operation retrieves a list of all the policy definition versions for the given policy definition in the
     * given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policyDefinitionName The name of the policy definition.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicyDefinitionVersionInner> listByManagementGroup(String managementGroupName,
        String policyDefinitionName, Integer top, Context context);
}
