// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentIdentity;
import com.azure.resourcemanager.resources.models.DeploymentProperties;
import java.io.IOException;
import java.util.Map;

/**
 * Deployment operation parameters.
 */
@Fluent
public final class DeploymentInner implements JsonSerializable<DeploymentInner> {
    /*
     * The location to store the deployment data.
     */
    private String location;

    /*
     * The deployment properties.
     */
    private DeploymentProperties properties;

    /*
     * Deployment tags
     */
    private Map<String, String> tags;

    /*
     * The Managed Identity configuration for a deployment.
     */
    private DeploymentIdentity identity;

    /**
     * Creates an instance of DeploymentInner class.
     */
    public DeploymentInner() {
    }

    /**
     * Get the location property: The location to store the deployment data.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location to store the deployment data.
     * 
     * @param location the location value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the properties property: The deployment properties.
     * 
     * @return the properties value.
     */
    public DeploymentProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The deployment properties.
     * 
     * @param properties the properties value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withProperties(DeploymentProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the tags property: Deployment tags.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Deployment tags.
     * 
     * @param tags the tags value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the identity property: The Managed Identity configuration for a deployment.
     * 
     * @return the identity value.
     */
    public DeploymentIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The Managed Identity configuration for a deployment.
     * 
     * @param identity the identity value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withIdentity(DeploymentIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property properties in model DeploymentInner"));
        } else {
            properties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeploymentInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeploymentInner.
     */
    public static DeploymentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentInner deserializedDeploymentInner = new DeploymentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedDeploymentInner.properties = DeploymentProperties.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedDeploymentInner.location = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeploymentInner.tags = tags;
                } else if ("identity".equals(fieldName)) {
                    deserializedDeploymentInner.identity = DeploymentIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentInner;
        });
    }
}
