// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.EnforcementMode;
import com.azure.resourcemanager.resources.models.Identity;
import com.azure.resourcemanager.resources.models.NonComplianceMessage;
import com.azure.resourcemanager.resources.models.OverrideModel;
import com.azure.resourcemanager.resources.models.ParameterValuesValue;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The policy assignment.
 */
@Fluent
public final class PolicyAssignmentInner extends ProxyResource {
    /*
     * Properties for the policy assignment.
     */
    private PolicyAssignmentProperties innerProperties;

    /*
     * The location of the policy assignment. Only required when utilizing managed identity.
     */
    private String location;

    /*
     * The managed identity associated with the policy assignment.
     */
    private Identity identity;

    /*
     * The system metadata relating to this resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PolicyAssignmentInner class.
     */
    public PolicyAssignmentInner() {
    }

    /**
     * Get the innerProperties property: Properties for the policy assignment.
     * 
     * @return the innerProperties value.
     */
    private PolicyAssignmentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the location property: The location of the policy assignment. Only required when utilizing managed identity.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the policy assignment. Only required when utilizing managed identity.
     * 
     * @param location the location value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the identity property: The managed identity associated with the policy assignment.
     * 
     * @return the identity value.
     */
    public Identity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The managed identity associated with the policy assignment.
     * 
     * @param identity the identity value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the systemData property: The system metadata relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the displayName property: The display name of the policy assignment.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: The display name of the policy assignment.
     * 
     * @param displayName the displayName value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the policyDefinitionId property: The ID of the policy definition or policy set definition being assigned.
     * 
     * @return the policyDefinitionId value.
     */
    public String policyDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyDefinitionId();
    }

    /**
     * Set the policyDefinitionId property: The ID of the policy definition or policy set definition being assigned.
     * 
     * @param policyDefinitionId the policyDefinitionId value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withPolicyDefinitionId(String policyDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withPolicyDefinitionId(policyDefinitionId);
        return this;
    }

    /**
     * Get the definitionVersion property: The version of the policy definition to use.
     * 
     * @return the definitionVersion value.
     */
    public String definitionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().definitionVersion();
    }

    /**
     * Set the definitionVersion property: The version of the policy definition to use.
     * 
     * @param definitionVersion the definitionVersion value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withDefinitionVersion(String definitionVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withDefinitionVersion(definitionVersion);
        return this;
    }

    /**
     * Get the latestDefinitionVersion property: The latest version of the policy definition available. This is only
     * present if requested via the $expand query parameter.
     * 
     * @return the latestDefinitionVersion value.
     */
    public String latestDefinitionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().latestDefinitionVersion();
    }

    /**
     * Get the effectiveDefinitionVersion property: The effective version of the policy definition in use. This is only
     * present if requested via the $expand query parameter.
     * 
     * @return the effectiveDefinitionVersion value.
     */
    public String effectiveDefinitionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().effectiveDefinitionVersion();
    }

    /**
     * Get the scope property: The scope for the policy assignment.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Get the notScopes property: The policy's excluded scopes.
     * 
     * @return the notScopes value.
     */
    public List<String> notScopes() {
        return this.innerProperties() == null ? null : this.innerProperties().notScopes();
    }

    /**
     * Set the notScopes property: The policy's excluded scopes.
     * 
     * @param notScopes the notScopes value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withNotScopes(List<String> notScopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withNotScopes(notScopes);
        return this;
    }

    /**
     * Get the parameters property: The parameter values for the assigned policy rule. The keys are the parameter names.
     * 
     * @return the parameters value.
     */
    public Map<String, ParameterValuesValue> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: The parameter values for the assigned policy rule. The keys are the parameter names.
     * 
     * @param parameters the parameters value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withParameters(Map<String, ParameterValuesValue> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Get the description property: This message will be part of response in case of policy violation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: This message will be part of response in case of policy violation.
     * 
     * @param description the description value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the metadata property: The policy assignment metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @return the metadata value.
     */
    public Object metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    /**
     * Set the metadata property: The policy assignment metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @param metadata the metadata value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withMetadata(Object metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    /**
     * Get the enforcementMode property: The policy assignment enforcement mode. Possible values are Default and
     * DoNotEnforce.
     * 
     * @return the enforcementMode value.
     */
    public EnforcementMode enforcementMode() {
        return this.innerProperties() == null ? null : this.innerProperties().enforcementMode();
    }

    /**
     * Set the enforcementMode property: The policy assignment enforcement mode. Possible values are Default and
     * DoNotEnforce.
     * 
     * @param enforcementMode the enforcementMode value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withEnforcementMode(EnforcementMode enforcementMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withEnforcementMode(enforcementMode);
        return this;
    }

    /**
     * Get the nonComplianceMessages property: The messages that describe why a resource is non-compliant with the
     * policy.
     * 
     * @return the nonComplianceMessages value.
     */
    public List<NonComplianceMessage> nonComplianceMessages() {
        return this.innerProperties() == null ? null : this.innerProperties().nonComplianceMessages();
    }

    /**
     * Set the nonComplianceMessages property: The messages that describe why a resource is non-compliant with the
     * policy.
     * 
     * @param nonComplianceMessages the nonComplianceMessages value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withNonComplianceMessages(List<NonComplianceMessage> nonComplianceMessages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withNonComplianceMessages(nonComplianceMessages);
        return this;
    }

    /**
     * Get the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @return the resourceSelectors value.
     */
    public List<ResourceSelector> resourceSelectors() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceSelectors();
    }

    /**
     * Set the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @param resourceSelectors the resourceSelectors value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withResourceSelectors(resourceSelectors);
        return this;
    }

    /**
     * Get the overrides property: The policy property value override.
     * 
     * @return the overrides value.
     */
    public List<OverrideModel> overrides() {
        return this.innerProperties() == null ? null : this.innerProperties().overrides();
    }

    /**
     * Set the overrides property: The policy property value override.
     * 
     * @param overrides the overrides value to set.
     * @return the PolicyAssignmentInner object itself.
     */
    public PolicyAssignmentInner withOverrides(List<OverrideModel> overrides) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyAssignmentProperties();
        }
        this.innerProperties().withOverrides(overrides);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyAssignmentInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyAssignmentInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PolicyAssignmentInner.
     */
    public static PolicyAssignmentInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyAssignmentInner deserializedPolicyAssignmentInner = new PolicyAssignmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.innerProperties = PolicyAssignmentProperties.fromJson(reader);
                } else if ("location".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.location = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.identity = Identity.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedPolicyAssignmentInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyAssignmentInner;
        });
    }
}
