// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AssignmentScopeValidation;
import com.azure.resourcemanager.resources.models.ExemptionCategory;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The policy exemption properties.
 */
@Fluent
public final class PolicyExemptionProperties implements JsonSerializable<PolicyExemptionProperties> {
    /*
     * The ID of the policy assignment that is being exempted.
     */
    private String policyAssignmentId;

    /*
     * The policy definition reference ID list when the associated policy assignment is an assignment of a policy set
     * definition.
     */
    private List<String> policyDefinitionReferenceIds;

    /*
     * The policy exemption category. Possible values are Waiver and Mitigated.
     */
    private ExemptionCategory exemptionCategory;

    /*
     * The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the policy exemption.
     */
    private OffsetDateTime expiresOn;

    /*
     * The display name of the policy exemption.
     */
    private String displayName;

    /*
     * The description of the policy exemption.
     */
    private String description;

    /*
     * The policy exemption metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    private Object metadata;

    /*
     * The resource selector list to filter policies by resource properties.
     */
    private List<ResourceSelector> resourceSelectors;

    /*
     * The option whether validate the exemption is at or under the assignment scope.
     */
    private AssignmentScopeValidation assignmentScopeValidation;

    /**
     * Creates an instance of PolicyExemptionProperties class.
     */
    public PolicyExemptionProperties() {
    }

    /**
     * Get the policyAssignmentId property: The ID of the policy assignment that is being exempted.
     * 
     * @return the policyAssignmentId value.
     */
    public String policyAssignmentId() {
        return this.policyAssignmentId;
    }

    /**
     * Set the policyAssignmentId property: The ID of the policy assignment that is being exempted.
     * 
     * @param policyAssignmentId the policyAssignmentId value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties withPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    /**
     * Get the policyDefinitionReferenceIds property: The policy definition reference ID list when the associated policy
     * assignment is an assignment of a policy set definition.
     * 
     * @return the policyDefinitionReferenceIds value.
     */
    public List<String> policyDefinitionReferenceIds() {
        return this.policyDefinitionReferenceIds;
    }

    /**
     * Set the policyDefinitionReferenceIds property: The policy definition reference ID list when the associated policy
     * assignment is an assignment of a policy set definition.
     * 
     * @param policyDefinitionReferenceIds the policyDefinitionReferenceIds value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties withPolicyDefinitionReferenceIds(List<String> policyDefinitionReferenceIds) {
        this.policyDefinitionReferenceIds = policyDefinitionReferenceIds;
        return this;
    }

    /**
     * Get the exemptionCategory property: The policy exemption category. Possible values are Waiver and Mitigated.
     * 
     * @return the exemptionCategory value.
     */
    public ExemptionCategory exemptionCategory() {
        return this.exemptionCategory;
    }

    /**
     * Set the exemptionCategory property: The policy exemption category. Possible values are Waiver and Mitigated.
     * 
     * @param exemptionCategory the exemptionCategory value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties withExemptionCategory(ExemptionCategory exemptionCategory) {
        this.exemptionCategory = exemptionCategory;
        return this;
    }

    /**
     * Get the expiresOn property: The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the
     * policy exemption.
     * 
     * @return the expiresOn value.
     */
    public OffsetDateTime expiresOn() {
        return this.expiresOn;
    }

    /**
     * Set the expiresOn property: The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the
     * policy exemption.
     * 
     * @param expiresOn the expiresOn value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties withExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    /**
     * Get the displayName property: The display name of the policy exemption.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the policy exemption.
     * 
     * @param displayName the displayName value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The description of the policy exemption.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description of the policy exemption.
     * 
     * @param description the description value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the metadata property: The policy exemption metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @return the metadata value.
     */
    public Object metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The policy exemption metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @param metadata the metadata value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @return the resourceSelectors value.
     */
    public List<ResourceSelector> resourceSelectors() {
        return this.resourceSelectors;
    }

    /**
     * Set the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @param resourceSelectors the resourceSelectors value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        this.resourceSelectors = resourceSelectors;
        return this;
    }

    /**
     * Get the assignmentScopeValidation property: The option whether validate the exemption is at or under the
     * assignment scope.
     * 
     * @return the assignmentScopeValidation value.
     */
    public AssignmentScopeValidation assignmentScopeValidation() {
        return this.assignmentScopeValidation;
    }

    /**
     * Set the assignmentScopeValidation property: The option whether validate the exemption is at or under the
     * assignment scope.
     * 
     * @param assignmentScopeValidation the assignmentScopeValidation value to set.
     * @return the PolicyExemptionProperties object itself.
     */
    public PolicyExemptionProperties
        withAssignmentScopeValidation(AssignmentScopeValidation assignmentScopeValidation) {
        this.assignmentScopeValidation = assignmentScopeValidation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (policyAssignmentId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property policyAssignmentId in model PolicyExemptionProperties"));
        }
        if (exemptionCategory() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property exemptionCategory in model PolicyExemptionProperties"));
        }
        if (resourceSelectors() != null) {
            resourceSelectors().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PolicyExemptionProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("exemptionCategory",
            this.exemptionCategory == null ? null : this.exemptionCategory.toString());
        jsonWriter.writeArrayField("policyDefinitionReferenceIds", this.policyDefinitionReferenceIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("expiresOn",
            this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        if (this.metadata != null) {
            jsonWriter.writeUntypedField("metadata", this.metadata);
        }
        jsonWriter.writeArrayField("resourceSelectors", this.resourceSelectors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("assignmentScopeValidation",
            this.assignmentScopeValidation == null ? null : this.assignmentScopeValidation.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyExemptionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyExemptionProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PolicyExemptionProperties.
     */
    public static PolicyExemptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyExemptionProperties deserializedPolicyExemptionProperties = new PolicyExemptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.policyAssignmentId = reader.getString();
                } else if ("exemptionCategory".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.exemptionCategory
                        = ExemptionCategory.fromString(reader.getString());
                } else if ("policyDefinitionReferenceIds".equals(fieldName)) {
                    List<String> policyDefinitionReferenceIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedPolicyExemptionProperties.policyDefinitionReferenceIds = policyDefinitionReferenceIds;
                } else if ("expiresOn".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.expiresOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("displayName".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.description = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.metadata = reader.readUntyped();
                } else if ("resourceSelectors".equals(fieldName)) {
                    List<ResourceSelector> resourceSelectors
                        = reader.readArray(reader1 -> ResourceSelector.fromJson(reader1));
                    deserializedPolicyExemptionProperties.resourceSelectors = resourceSelectors;
                } else if ("assignmentScopeValidation".equals(fieldName)) {
                    deserializedPolicyExemptionProperties.assignmentScopeValidation
                        = AssignmentScopeValidation.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyExemptionProperties;
        });
    }
}
