// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * HTTP message.
 */
@Fluent
public final class HttpMessage implements JsonSerializable<HttpMessage> {
    /*
     * HTTP message content.
     */
    private Object content;

    /**
     * Creates an instance of HttpMessage class.
     */
    public HttpMessage() {
    }

    /**
     * Get the content property: HTTP message content.
     * 
     * @return the content value.
     */
    public Object content() {
        return this.content;
    }

    /**
     * Set the content property: HTTP message content.
     * 
     * @param content the content value to set.
     * @return the HttpMessage object itself.
     */
    public HttpMessage withContent(Object content) {
        this.content = content;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.content != null) {
            jsonWriter.writeUntypedField("content", this.content);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpMessage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpMessage.
     */
    public static HttpMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpMessage deserializedHttpMessage = new HttpMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("content".equals(fieldName)) {
                    deserializedHttpMessage.content = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpMessage;
        });
    }
}
