// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about shared availability zone.
 */
@Immutable
public final class Peers implements JsonSerializable<Peers> {
    /*
     * The subscription ID.
     */
    private String subscriptionId;

    /*
     * The availabilityZone.
     */
    private String availabilityZone;

    /**
     * Creates an instance of Peers class.
     */
    public Peers() {
    }

    /**
     * Get the subscriptionId property: The subscription ID.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Get the availabilityZone property: The availabilityZone.
     * 
     * @return the availabilityZone value.
     */
    public String availabilityZone() {
        return this.availabilityZone;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Peers from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Peers if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Peers.
     */
    public static Peers fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Peers deserializedPeers = new Peers();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subscriptionId".equals(fieldName)) {
                    deserializedPeers.subscriptionId = reader.getString();
                } else if ("availabilityZone".equals(fieldName)) {
                    deserializedPeers.availabilityZone = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPeers;
        });
    }
}
