/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.ManagementLockProperties;
import com.azure.resourcemanager.resources.models.LockLevel;
import com.azure.resourcemanager.resources.models.ManagementLockOwner;
import java.io.IOException;
import java.util.List;

public final class ManagementLockObjectInner
extends ProxyResource {
    private ManagementLockProperties innerProperties = new ManagementLockProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ManagementLockObjectInner.class);

    private ManagementLockProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public LockLevel level() {
        return this.innerProperties() == null ? null : this.innerProperties().level();
    }

    public ManagementLockObjectInner withLevel(LockLevel level) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementLockProperties();
        }
        this.innerProperties().withLevel(level);
        return this;
    }

    public String notes() {
        return this.innerProperties() == null ? null : this.innerProperties().notes();
    }

    public ManagementLockObjectInner withNotes(String notes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementLockProperties();
        }
        this.innerProperties().withNotes(notes);
        return this;
    }

    public List<ManagementLockOwner> owners() {
        return this.innerProperties() == null ? null : this.innerProperties().owners();
    }

    public ManagementLockObjectInner withOwners(List<ManagementLockOwner> owners) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagementLockProperties();
        }
        this.innerProperties().withOwners(owners);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ManagementLockObjectInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagementLockObjectInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementLockObjectInner)((Object)jsonReader.readObject(reader -> {
            ManagementLockObjectInner deserializedManagementLockObjectInner = new ManagementLockObjectInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagementLockObjectInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagementLockObjectInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagementLockObjectInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagementLockObjectInner.innerProperties = ManagementLockProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementLockObjectInner;
        }));
    }
}

