/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DeploymentExtensionDefinition;
import java.io.IOException;

public class ResourceReference
implements JsonSerializable<ResourceReference> {
    private String id;
    private DeploymentExtensionDefinition extension;
    private String resourceType;
    private Object identifiers;
    private String apiVersion;

    public String id() {
        return this.id;
    }

    public DeploymentExtensionDefinition extension() {
        return this.extension;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Object identifiers() {
        return this.identifiers;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public void validate() {
        if (this.extension() != null) {
            this.extension().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ResourceReference fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceReference)jsonReader.readObject(reader -> {
            ResourceReference deserializedResourceReference = new ResourceReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceReference.id = reader.getString();
                    continue;
                }
                if ("extension".equals(fieldName)) {
                    deserializedResourceReference.extension = DeploymentExtensionDefinition.fromJson(reader);
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedResourceReference.resourceType = reader.getString();
                    continue;
                }
                if ("identifiers".equals(fieldName)) {
                    deserializedResourceReference.identifiers = reader.readUntyped();
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedResourceReference.apiVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceReference;
        });
    }
}

