/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.LockLevel;
import com.azure.resourcemanager.resources.models.ManagementLockOwner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ManagementLockObjectInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ManagementLockObjectInner.class);
    @JsonProperty(value="properties.level", required=true)
    private LockLevel level;
    @JsonProperty(value="properties.notes")
    private String notes;
    @JsonProperty(value="properties.owners")
    private List<ManagementLockOwner> owners;

    public LockLevel level() {
        return this.level;
    }

    public ManagementLockObjectInner withLevel(LockLevel level) {
        this.level = level;
        return this;
    }

    public String notes() {
        return this.notes;
    }

    public ManagementLockObjectInner withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public List<ManagementLockOwner> owners() {
        return this.owners;
    }

    public ManagementLockObjectInner withOwners(List<ManagementLockOwner> owners) {
        this.owners = owners;
        return this;
    }

    public void validate() {
        if (this.level() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property level in model ManagementLockObjectInner"));
        }
        if (this.owners() != null) {
            this.owners().forEach(e -> e.validate());
        }
    }
}

