/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm;

import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.HasServiceClient;

public abstract class Manager<InnerT>
implements HasServiceClient<InnerT> {
    private ResourceManager resourceManager;
    private final String subscriptionId;
    private final AzureEnvironment environment;
    private final HttpPipeline httpPipeline;
    private final InnerT innerManagementClient;

    protected Manager(HttpPipeline httpPipeline, AzureProfile profile, InnerT innerManagementClient) {
        this.httpPipeline = httpPipeline;
        if (httpPipeline != null) {
            this.resourceManager = AzureConfigurableImpl.configureHttpPipeline(httpPipeline, ResourceManager.configure()).authenticate(null, profile).withDefaultSubscription();
        }
        this.subscriptionId = profile.getSubscriptionId();
        this.environment = profile.getEnvironment();
        this.innerManagementClient = innerManagementClient;
    }

    @Override
    public InnerT serviceClient() {
        return this.innerManagementClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public AzureEnvironment environment() {
        return this.environment;
    }

    protected final void withResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager resourceManager() {
        return this.resourceManager;
    }

    public HttpPipeline httpPipeline() {
        return this.httpPipeline;
    }
}

