/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.PolicyDefinitionsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicyDefinitionInner;
import com.azure.resourcemanager.resources.implementation.PolicyClientImpl;
import com.azure.resourcemanager.resources.models.PolicyDefinitionListResult;
import reactor.core.publisher.Mono;

public final class PolicyDefinitionsClientImpl
implements PolicyDefinitionsClient {
    private final ClientLogger logger = new ClientLogger(PolicyDefinitionsClientImpl.class);
    private final PolicyDefinitionsService service;
    private final PolicyClientImpl client;

    PolicyDefinitionsClientImpl(PolicyClientImpl client) {
        this.service = (PolicyDefinitionsService)RestProxy.create(PolicyDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionInner>> createOrUpdateWithResponseAsync(String policyDefinitionName, PolicyDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionInner>> createOrUpdateWithResponseAsync(String policyDefinitionName, PolicyDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionInner> createOrUpdateAsync(String policyDefinitionName, PolicyDefinitionInner parameters) {
        return this.createOrUpdateWithResponseAsync(policyDefinitionName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionInner createOrUpdate(String policyDefinitionName, PolicyDefinitionInner parameters) {
        return (PolicyDefinitionInner)((Object)this.createOrUpdateAsync(policyDefinitionName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionInner> createOrUpdateWithResponse(String policyDefinitionName, PolicyDefinitionInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(policyDefinitionName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String policyDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String policyDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String policyDefinitionName) {
        return this.deleteWithResponseAsync(policyDefinitionName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String policyDefinitionName) {
        this.deleteAsync(policyDefinitionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String policyDefinitionName, Context context) {
        return (Response)this.deleteWithResponseAsync(policyDefinitionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionInner>> getWithResponseAsync(String policyDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionInner>> getWithResponseAsync(String policyDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionInner> getAsync(String policyDefinitionName) {
        return this.getWithResponseAsync(policyDefinitionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionInner get(String policyDefinitionName) {
        return (PolicyDefinitionInner)((Object)this.getAsync(policyDefinitionName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionInner> getWithResponse(String policyDefinitionName, Context context) {
        return (Response)this.getWithResponseAsync(policyDefinitionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionInner>> getBuiltInWithResponseAsync(String policyDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBuiltIn(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionInner>> getBuiltInWithResponseAsync(String policyDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBuiltIn(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionInner> getBuiltInAsync(String policyDefinitionName) {
        return this.getBuiltInWithResponseAsync(policyDefinitionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionInner getBuiltIn(String policyDefinitionName) {
        return (PolicyDefinitionInner)((Object)this.getBuiltInAsync(policyDefinitionName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionInner> getBuiltInWithResponse(String policyDefinitionName, Context context) {
        return (Response)this.getBuiltInWithResponseAsync(policyDefinitionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", managementGroupId, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", managementGroupId, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionInner> createOrUpdateAtManagementGroupAsync(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionInner createOrUpdateAtManagementGroup(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters) {
        return (PolicyDefinitionInner)((Object)this.createOrUpdateAtManagementGroupAsync(policyDefinitionName, managementGroupId, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionInner> createOrUpdateAtManagementGroupWithResponse(String policyDefinitionName, String managementGroupId, PolicyDefinitionInner parameters, Context context) {
        return (Response)this.createOrUpdateAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", managementGroupId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", managementGroupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupAsync(String policyDefinitionName, String managementGroupId) {
        return this.deleteAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtManagementGroup(String policyDefinitionName, String managementGroupId) {
        this.deleteAtManagementGroupAsync(policyDefinitionName, managementGroupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAtManagementGroupWithResponse(String policyDefinitionName, String managementGroupId, Context context) {
        return (Response)this.deleteAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicyDefinitionInner>> getAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", managementGroupId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicyDefinitionInner>> getAtManagementGroupWithResponseAsync(String policyDefinitionName, String managementGroupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policyDefinitionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyDefinitionName is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtManagementGroup(this.client.getEndpoint(), policyDefinitionName, "2020-09-01", managementGroupId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicyDefinitionInner> getAtManagementGroupAsync(String policyDefinitionName, String managementGroupId) {
        return this.getAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PolicyDefinitionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicyDefinitionInner getAtManagementGroup(String policyDefinitionName, String managementGroupId) {
        return (PolicyDefinitionInner)((Object)this.getAtManagementGroupAsync(policyDefinitionName, managementGroupId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicyDefinitionInner> getAtManagementGroupWithResponse(String policyDefinitionName, String managementGroupId, Context context) {
        return (Response)this.getAtManagementGroupWithResponseAsync(policyDefinitionName, managementGroupId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2020-09-01", this.client.getSubscriptionId(), filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listSinglePageAsync(String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2020-09-01", this.client.getSubscriptionId(), filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionInner> listAsync(String filter, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionInner> listAsync() {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyDefinitionInner> listAsync(String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, top, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionInner> list() {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listAsync(filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionInner> list(String filter, Integer top, Context context) {
        return new PagedIterable(this.listAsync(filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listBuiltInSinglePageAsync(String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuiltIn(this.client.getEndpoint(), "2020-09-01", filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listBuiltInSinglePageAsync(String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuiltIn(this.client.getEndpoint(), "2020-09-01", filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionInner> listBuiltInAsync(String filter, Integer top) {
        return new PagedFlux(() -> this.listBuiltInSinglePageAsync(filter, top), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionInner> listBuiltInAsync() {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listBuiltInSinglePageAsync(filter, top), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyDefinitionInner> listBuiltInAsync(String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listBuiltInSinglePageAsync(filter, top, context), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionInner> listBuiltIn() {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listBuiltInAsync(filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionInner> listBuiltIn(String filter, Integer top, Context context) {
        return new PagedIterable(this.listBuiltInAsync(filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listByManagementGroupSinglePageAsync(String managementGroupId, String filter, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByManagementGroup(this.client.getEndpoint(), "2020-09-01", managementGroupId, filter, top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listByManagementGroupSinglePageAsync(String managementGroupId, String filter, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2020-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroup(this.client.getEndpoint(), "2020-09-01", managementGroupId, filter, top, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionInner> listByManagementGroupAsync(String managementGroupId, String filter, Integer top) {
        return new PagedFlux(() -> this.listByManagementGroupSinglePageAsync(managementGroupId, filter, top), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicyDefinitionInner> listByManagementGroupAsync(String managementGroupId) {
        String filter = null;
        Integer top = null;
        return new PagedFlux(() -> this.listByManagementGroupSinglePageAsync(managementGroupId, filter, top), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicyDefinitionInner> listByManagementGroupAsync(String managementGroupId, String filter, Integer top, Context context) {
        return new PagedFlux(() -> this.listByManagementGroupSinglePageAsync(managementGroupId, filter, top, context), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionInner> listByManagementGroup(String managementGroupId) {
        String filter = null;
        Integer top = null;
        return new PagedIterable(this.listByManagementGroupAsync(managementGroupId, filter, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicyDefinitionInner> listByManagementGroup(String managementGroupId, String filter, Integer top, Context context) {
        return new PagedIterable(this.listByManagementGroupAsync(managementGroupId, filter, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuiltInNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuiltInNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicyDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicyDefinitionListResult)res.getValue()).value(), ((PolicyDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyClientPolicyDe")
    private static interface PolicyDefinitionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") PolicyDefinitionInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> getBuiltIn(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> createOrUpdateAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, @BodyParam(value="application/json") PolicyDefinitionInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionInner>> getAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="policyDefinitionName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="managementGroupId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$filter", encoded=true) String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policyDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listBuiltIn(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="$filter", encoded=true) String var3, @QueryParam(value="$top") Integer var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policyDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listByManagementGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="managementGroupId") String var3, @QueryParam(value="$filter", encoded=true) String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listBuiltInNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicyDefinitionListResult>> listByManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

