// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.ResourceNameStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Resource Name valid if not a reserved word, does not contain a reserved word and does not start with a reserved word.
 */
@Fluent
public final class CheckResourceNameResultInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CheckResourceNameResultInner.class);

    /*
     * Name of Resource
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Type of Resource
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * Is the resource name Allowed or Reserved
     */
    @JsonProperty(value = "status")
    private ResourceNameStatus status;

    /**
     * Get the name property: Name of Resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of Resource.
     *
     * @param name the name value to set.
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Type of Resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of Resource.
     *
     * @param type the type value to set.
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the status property: Is the resource name Allowed or Reserved.
     *
     * @return the status value.
     */
    public ResourceNameStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Is the resource name Allowed or Reserved.
     *
     * @param status the status value to set.
     * @return the CheckResourceNameResultInner object itself.
     */
    public CheckResourceNameResultInner withStatus(ResourceNameStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
