// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.DataManifestCustomResourceFunctionDefinition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The resource functions supported by a manifest. */
@Fluent
public final class DataManifestResourceFunctionsDefinition {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DataManifestResourceFunctionsDefinition.class);

    /*
     * The standard resource functions (subscription and/or resourceGroup).
     */
    @JsonProperty(value = "standard")
    private List<String> standard;

    /*
     * An array of data manifest custom resource definition.
     */
    @JsonProperty(value = "custom")
    private List<DataManifestCustomResourceFunctionDefinition> custom;

    /**
     * Get the standard property: The standard resource functions (subscription and/or resourceGroup).
     *
     * @return the standard value.
     */
    public List<String> standard() {
        return this.standard;
    }

    /**
     * Set the standard property: The standard resource functions (subscription and/or resourceGroup).
     *
     * @param standard the standard value to set.
     * @return the DataManifestResourceFunctionsDefinition object itself.
     */
    public DataManifestResourceFunctionsDefinition withStandard(List<String> standard) {
        this.standard = standard;
        return this;
    }

    /**
     * Get the custom property: An array of data manifest custom resource definition.
     *
     * @return the custom value.
     */
    public List<DataManifestCustomResourceFunctionDefinition> custom() {
        return this.custom;
    }

    /**
     * Set the custom property: An array of data manifest custom resource definition.
     *
     * @param custom the custom value to set.
     * @return the DataManifestResourceFunctionsDefinition object itself.
     */
    public DataManifestResourceFunctionsDefinition withCustom(
        List<DataManifestCustomResourceFunctionDefinition> custom) {
        this.custom = custom;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (custom() != null) {
            custom().forEach(e -> e.validate());
        }
    }
}
