// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List of policy set definitions. */
@Fluent
public final class PolicySetDefinitionListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PolicySetDefinitionListResult.class);

    /*
     * An array of policy set definitions.
     */
    @JsonProperty(value = "value")
    private List<PolicySetDefinitionInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: An array of policy set definitions.
     *
     * @return the value value.
     */
    public List<PolicySetDefinitionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of policy set definitions.
     *
     * @param value the value value to set.
     * @return the PolicySetDefinitionListResult object itself.
     */
    public PolicySetDefinitionListResult withValue(List<PolicySetDefinitionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to use for getting the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the PolicySetDefinitionListResult object itself.
     */
    public PolicySetDefinitionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
