/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.search.fluent.AdminKeysClient;
import com.azure.resourcemanager.search.fluent.models.AdminKeyResultInner;
import com.azure.resourcemanager.search.implementation.SearchManagementClientImpl;
import com.azure.resourcemanager.search.models.AdminKeyKind;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class AdminKeysClientImpl
implements AdminKeysClient {
    private final ClientLogger logger = new ClientLogger(AdminKeysClientImpl.class);
    private final AdminKeysService service;
    private final SearchManagementClientImpl client;

    AdminKeysClientImpl(SearchManagementClientImpl client) {
        this.service = (AdminKeysService)RestProxy.create(AdminKeysService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AdminKeyResultInner>> getWithResponseAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdminKeyResultInner>> getWithResponseAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AdminKeyResultInner> getAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        return this.getWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AdminKeyResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AdminKeyResultInner> getAsync(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return this.getWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AdminKeyResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdminKeyResultInner get(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return (AdminKeyResultInner)this.getAsync(resourceGroupName, searchServiceName, clientRequestId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdminKeyResultInner> getWithResponse(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AdminKeyResultInner>> regenerateWithResponseAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (keyKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyKind is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerate(this.client.getEndpoint(), resourceGroupName, searchServiceName, keyKind, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdminKeyResultInner>> regenerateWithResponseAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (keyKind == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyKind is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerate(this.client.getEndpoint(), resourceGroupName, searchServiceName, keyKind, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AdminKeyResultInner> regenerateAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, UUID clientRequestId) {
        return this.regenerateWithResponseAsync(resourceGroupName, searchServiceName, keyKind, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AdminKeyResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AdminKeyResultInner> regenerateAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        UUID clientRequestId = null;
        return this.regenerateWithResponseAsync(resourceGroupName, searchServiceName, keyKind, clientRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AdminKeyResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdminKeyResultInner regenerate(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        UUID clientRequestId = null;
        return (AdminKeyResultInner)this.regenerateAsync(resourceGroupName, searchServiceName, keyKind, clientRequestId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdminKeyResultInner> regenerateWithResponse(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, UUID clientRequestId, Context context) {
        return (Response)this.regenerateWithResponseAsync(resourceGroupName, searchServiceName, keyKind, clientRequestId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SearchManagementClie")
    private static interface AdminKeysService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/listAdminKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdminKeyResultInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/regenerateAdminKey/{keyKind}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdminKeyResultInner>> regenerate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="keyKind") AdminKeyKind var4, @HeaderParam(value="x-ms-client-request-id") UUID var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

