// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response containing a list of Shared Private Link Resources. */
@Fluent
public final class SharedPrivateLinkResourceListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SharedPrivateLinkResourceListResult.class);

    /*
     * The list of Shared Private Link Resources.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<SharedPrivateLinkResourceInner> value;

    /*
     * The URL to get the next set of shared private link resources, if there
     * are any.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: The list of Shared Private Link Resources.
     *
     * @return the value value.
     */
    public List<SharedPrivateLinkResourceInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: The URL to get the next set of shared private link resources, if there are any.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of shared private link resources, if there are any.
     *
     * @param nextLink the nextLink value to set.
     * @return the SharedPrivateLinkResourceListResult object itself.
     */
    public SharedPrivateLinkResourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
